/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.storage.dataobjects.keyed;

import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.configurate.AbstractConfigurateBackedDataObject;
import io.github.nucleuspowered.storage.dataobjects.keyed.DataKey;
import io.github.nucleuspowered.storage.dataobjects.keyed.IKeyedDataObject;
import java.util.Optional;
import javax.annotation.Nullable;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;

public class AbstractKeyBasedDataObject<T extends IKeyedDataObject<T>>
extends AbstractConfigurateBackedDataObject
implements IKeyedDataObject<T> {
    private transient boolean isDirty = false;

    @Override
    public final void markDirty() {
        this.isDirty = true;
    }

    @Override
    public final void markDirty(boolean markDirty) {
        this.isDirty = markDirty;
    }

    @Override
    public final boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean has(DataKey<?, ? extends T> dataKey) {
        return !this.getNode(dataKey.getKey()).isVirtual();
    }

    @Override
    public <V> IKeyedDataObject.Value<V> getAndSet(DataKey<V, ? extends T> dataKey) {
        return new ValueImpl(this.getNullable(dataKey), dataKey);
    }

    @Override
    @Nullable
    public <V> V getNullable(DataKey<V, ? extends T> dataKey) {
        try {
            return (V)this.getNode(dataKey.getKey()).getValue(dataKey.getType());
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Nullable
    public <V> V getOrDefault(DataKey<V, ? extends T> dataKey) {
        V t = this.getNullable((DataKey<V, ? extends T>)dataKey);
        if (t == null) {
            return dataKey.getDefault();
        }
        return t;
    }

    @Override
    public <V> Optional<V> get(DataKey<V, ? extends T> dataKey) {
        return Optional.ofNullable(this.getNullable(dataKey));
    }

    @Override
    public <V> boolean set(DataKey<V, ? extends T> dataKey, V data) {
        try {
            this.getNode(dataKey.getKey()).setValue(dataKey.getType(), data);
            this.markDirty();
            return true;
        }
        catch (ObjectMappingException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void remove(DataKey<?, ? extends T> dataKey) {
        this.getNode(dataKey.getKey()).setValue(null);
        this.markDirty();
    }

    private ConfigurationNode getNode(String[] key) {
        ConfigurationNode r = this.backingNode;
        for (String k : key) {
            r = r.getNode(new Object[]{k});
        }
        return r;
    }

    @Override
    public void setBackingNode(ConfigurationNode node) {
        this.markDirty(false);
        super.setBackingNode(node);
    }

    public class ValueImpl<V, B extends T>
    implements IKeyedDataObject.Value<V> {
        @Nullable
        private V value;
        private final DataKey<V, B> dataKey;

        private ValueImpl(V value, DataKey<V, B> dataKey) {
            this.value = value;
            this.dataKey = dataKey;
        }

        @Override
        public Optional<V> getValue() {
            return Optional.ofNullable(this.value);
        }

        @Override
        public void setValue(@Nullable V value) {
            this.value = value;
        }

        @Override
        public void close() {
            if (this.value == null) {
                AbstractKeyBasedDataObject.this.remove(this.dataKey);
            } else {
                AbstractKeyBasedDataObject.this.set(this.dataKey, this.value);
            }
        }
    }
}

