/*
 * Decompiled with CFR 0.152.
 */
package extracells.wireless;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.util.IConfigManager;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class ConfigManager
implements IConfigManager {
    private final Map<Settings, Enum<?>> settings = new EnumMap(Settings.class);
    private final NBTTagCompound tagCompound;

    public ConfigManager() {
        this(null);
    }

    public ConfigManager(NBTTagCompound tag) {
        this.tagCompound = tag;
        if (tag != null) {
            this.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
            this.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
            this.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
            this.readFromNBT((NBTTagCompound)tag.func_74737_b());
        }
    }

    public Set<Settings> getSettings() {
        return this.settings.keySet();
    }

    public void registerSetting(Settings settingName, Enum defaultValue) {
        this.settings.put(settingName, defaultValue);
    }

    public Enum<?> getSetting(Settings settingName) {
        Enum<?> oldValue = this.settings.get(settingName);
        if (oldValue != null) {
            return oldValue;
        }
        throw new IllegalStateException("Invalid Config setting. Expected a non-null value for " + settingName);
    }

    public Enum<?> putSetting(Settings settingName, Enum newValue) {
        Enum<?> oldValue = this.getSetting(settingName);
        this.settings.put(settingName, newValue);
        if (this.tagCompound != null) {
            this.writeToNBT(this.tagCompound);
        }
        return oldValue;
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
        for (Map.Entry<Settings, Enum<?>> entry : this.settings.entrySet()) {
            tagCompound.func_74778_a(entry.getKey().name(), this.settings.get(entry.getKey()).toString());
        }
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        for (Map.Entry<Settings, Enum<?>> entry : this.settings.entrySet()) {
            try {
                if (!tagCompound.func_74764_b(entry.getKey().name())) continue;
                String value = tagCompound.func_74779_i(entry.getKey().name());
                Enum<?> oldValue = this.settings.get(entry.getKey());
                Object newValue = Enum.valueOf(oldValue.getClass(), value);
                this.putSetting(entry.getKey(), (Enum)newValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

