/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.gui;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import openblocks.common.container.ContainerDonationStation;
import openblocks.common.tileentity.TileEntityDonationStation;
import openmods.Log;
import openmods.container.ContainerBase;
import openmods.gui.BaseGuiContainer;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentTextButton;

public class GuiDonationStation
extends BaseGuiContainer<ContainerDonationStation> {
    private final int PROMPT_REPLY_ACTION = 0;
    private URI displayedURI = null;
    private GuiComponentLabel lblModName = new GuiComponentLabel(55, 31, 100, 10, "");
    private GuiComponentTextButton buttonDonate;
    private GuiComponentLabel lblAuthors;

    public GuiDonationStation(ContainerDonationStation container) {
        super((ContainerBase)container, 176, 172, "openblocks.gui.donationstation");
        this.root.addComponent((BaseComponent)this.lblModName);
        this.lblAuthors = new GuiComponentLabel(55, 42, 200, 18, "").setScale(0.5f);
        this.root.addComponent((BaseComponent)this.lblAuthors);
        this.buttonDonate = new GuiComponentTextButton(31, 60, 115, 13, 0xFFFFFF);
        this.root.addComponent((BaseComponent)this.buttonDonate.setText("Donate to the author"));
        this.buttonDonate.setListener((component, x, y, button) -> {
            if (!this.buttonDonate.isButtonEnabled()) {
                return;
            }
            String donationUrl = ((TileEntityDonationStation)((Object)((Object)((ContainerDonationStation)this.getContainer()).getOwner()))).getDonationUrl();
            if (Strings.isNullOrEmpty((String)donationUrl)) {
                return;
            }
            URI uri = URI.create(donationUrl);
            if (Minecraft.func_71410_x().field_71474_y.field_74358_q) {
                this.displayedURI = uri;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, this.displayedURI.toString(), 0, false));
            } else {
                GuiDonationStation.openURI(uri);
            }
        });
    }

    public void preRender(float mouseX, float mouseY) {
        super.preRender(mouseX, mouseY);
        TileEntityDonationStation owner = (TileEntityDonationStation)((Object)((ContainerDonationStation)this.getContainer()).getOwner());
        if (owner.hasItem()) {
            String donateUrl = owner.getDonationUrl();
            this.buttonDonate.setButtonEnabled(!Strings.isNullOrEmpty((String)donateUrl));
            String name = owner.getModName();
            this.lblModName.setText(Strings.isNullOrEmpty((String)name) ? "Vanilla / Unknown" : name);
            List<String> authors = owner.getModAuthors();
            this.lblAuthors.setText(authors == null ? "" : Joiner.on((String)",").join(authors));
        } else {
            this.buttonDonate.setButtonEnabled(false);
            this.lblModName.setText("");
            this.lblAuthors.setText("");
        }
    }

    public void postRender(int mouseX, int mouseY) {
        super.postRender(mouseX, mouseY);
        if (this.lblAuthors.isOverflowing()) {
            this.lblAuthors.setTooltip(this.lblAuthors.getFormattedText(this.field_146289_q));
        } else {
            this.lblAuthors.clearTooltip();
        }
    }

    private static void openURI(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            Log.info((Throwable)e, (String)"Failed to open uri %s", (Object[])new Object[]{uri});
        }
    }

    public void func_73878_a(boolean result, int action) {
        if (action == 0 && result) {
            GuiDonationStation.openURI(this.displayedURI);
            this.displayedURI = null;
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }
}

