/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.block.canvas;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import org.apache.commons.lang3.tuple.Pair;

public class RenderLayerCache {
    private static final LayerRenderInfo EMPTY = new LayerRenderInfo((List<BlockRenderLayer>)ImmutableList.of(), false);
    private Map<BlockRenderLayer, LayerRenderInfo> baseRenderLayers;
    private final LoadingCache<Pair<IBlockState, BlockRenderLayer>, LayerRenderInfo> renderLayers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<IBlockState, BlockRenderLayer>, LayerRenderInfo>(){

        public LayerRenderInfo load(Pair<IBlockState, BlockRenderLayer> key) {
            IBlockState state = (IBlockState)key.getLeft();
            Block block = state.func_177230_c();
            return RenderLayerCache.getLayerRenderInfo((BlockRenderLayer)key.getRight(), (Predicate<BlockRenderLayer>)input -> block.canRenderInLayer(state, input));
        }
    });

    public RenderLayerCache(Predicate<BlockRenderLayer> baseModelLayers) {
        ImmutableMap.Builder baseBuilder = ImmutableMap.builder();
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            baseBuilder.put((Object)layer, (Object)RenderLayerCache.getLayerRenderInfo(layer, baseModelLayers));
        }
        this.baseRenderLayers = baseBuilder.build();
    }

    private static LayerRenderInfo getLayerRenderInfo(BlockRenderLayer renderLayer, Predicate<BlockRenderLayer> canRender) {
        if (canRender.apply((Object)BlockRenderLayer.TRANSLUCENT)) {
            if (renderLayer == BlockRenderLayer.TRANSLUCENT) {
                return new LayerRenderInfo((List<BlockRenderLayer>)ImmutableList.of((Object)BlockRenderLayer.TRANSLUCENT), true);
            }
            if (renderLayer == BlockRenderLayer.CUTOUT) {
                return new LayerRenderInfo(RenderLayerCache.checkSolidLayers(canRender), false);
            }
        } else if (renderLayer == BlockRenderLayer.CUTOUT) {
            return new LayerRenderInfo(RenderLayerCache.checkSolidLayers(canRender), true);
        }
        return EMPTY;
    }

    private static List<BlockRenderLayer> checkSolidLayers(Predicate<BlockRenderLayer> canRender) {
        ArrayList builder = Lists.newArrayListWithExpectedSize((int)3);
        RenderLayerCache.checkRenderLayer(BlockRenderLayer.SOLID, canRender, builder);
        RenderLayerCache.checkRenderLayer(BlockRenderLayer.CUTOUT_MIPPED, canRender, builder);
        RenderLayerCache.checkRenderLayer(BlockRenderLayer.CUTOUT, canRender, builder);
        return ImmutableList.copyOf((Collection)builder);
    }

    private static void checkRenderLayer(BlockRenderLayer layer, Predicate<BlockRenderLayer> canRender, List<BlockRenderLayer> output) {
        if (canRender.apply((Object)layer)) {
            output.add(layer);
        }
    }

    public LayerRenderInfo get(Optional<IBlockState> state, BlockRenderLayer renderLayer) {
        return state.isPresent() ? (LayerRenderInfo)this.renderLayers.getUnchecked((Object)Pair.of((Object)state.get(), (Object)renderLayer)) : this.baseRenderLayers.get(renderLayer);
    }

    public static class LayerRenderInfo {
        public final List<BlockRenderLayer> layers;
        public final boolean renderCovers;

        public LayerRenderInfo(List<BlockRenderLayer> layers, boolean renderCovers) {
            this.layers = layers;
            this.renderCovers = renderCovers;
        }
    }
}

