/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.clientnotif;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.registry.AutoLoad;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Triple;

@AutoLoad(value=true)
public class NeighborChangedMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public NeighborChangedMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        World world = IMalisisMessageHandler.getWorld(ctx);
        for (Triple t : message.list) {
            world.func_180495_p((BlockPos)t.getLeft()).func_189546_a(world, (BlockPos)t.getLeft(), (Block)t.getMiddle(), (BlockPos)t.getRight());
        }
    }

    public static void send(Chunk chunk, List<Triple<BlockPos, Block, BlockPos>> list) {
        Packet packet = new Packet(list);
        MalisisCore.network.sendToPlayersWatchingChunk(packet, chunk);
    }

    public static class Packet
    implements IMessage {
        private List<Triple<BlockPos, Block, BlockPos>> list = Lists.newArrayList();

        public Packet() {
        }

        public Packet(List<Triple<BlockPos, Block, BlockPos>> list) {
            this.list = list;
        }

        public void fromBytes(ByteBuf buf) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.list.add((Triple<BlockPos, Block, BlockPos>)Triple.of((Object)BlockPos.func_177969_a((long)buf.readLong()), (Object)Block.func_149729_e((int)buf.readInt()), (Object)BlockPos.func_177969_a((long)buf.readLong())));
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.list.size());
            for (Triple<BlockPos, Block, BlockPos> t : this.list) {
                buf.writeLong(((BlockPos)t.getLeft()).func_177986_g());
                buf.writeInt(Block.func_149682_b((Block)((Block)t.getMiddle())));
                buf.writeLong(((BlockPos)t.getRight()).func_177986_g());
            }
        }
    }
}

