/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class MapModelState
implements IModelState {
    private final ImmutableMap<Wrapper, IModelState> map;
    private final IModelState def;

    public MapModelState(Map<Wrapper, IModelState> map) {
        this(map, TRSRTransformation.identity());
    }

    public MapModelState(Map<Wrapper, IModelState> map, TRSRTransformation def) {
        this(map, (IModelState)def);
    }

    public MapModelState(Map<Wrapper, IModelState> map, IModelState def) {
        this.map = ImmutableMap.copyOf(map);
        this.def = def;
    }

    @Override
    public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
        if (!part.isPresent() || !this.map.containsKey((Object)part.get())) {
            return this.def.apply(part);
        }
        return ((IModelState)this.map.get((Object)part.get())).apply(Optional.empty());
    }

    public IModelState getState(Object obj) {
        Wrapper w = MapModelState.wrap(obj);
        if (!this.map.containsKey((Object)w)) {
            return this.def;
        }
        return (IModelState)this.map.get((Object)w);
    }

    public static Wrapper wrap(Object obj) {
        return new Wrapper(obj);
    }

    public static class Wrapper
    implements IModelPart {
        private final Object obj;

        public Wrapper(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Wrapper other = (Wrapper)obj;
            return Objects.equal((Object)this.obj, (Object)other.obj);
        }
    }
}

