/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiEditArray;
import net.minecraftforge.fml.client.config.GuiSelectString;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class GuiConfigEntries
extends bjm {
    public final GuiConfig owningScreen;
    public final bib a;
    public List<IConfigEntry> listEntries;
    public int maxLabelTextWidth = 0;
    public int maxEntryRightBound = 0;
    public int labelX;
    public int controlX;
    public int controlWidth;
    public int resetX;
    public int scrollBarX;

    public GuiConfigEntries(GuiConfig parent, bib mc) {
        super(mc, parent.l, parent.m, parent.titleLine2 != null ? 33 : 23, parent.m - 32, 20);
        this.owningScreen = parent;
        this.b(false);
        this.a = mc;
        this.listEntries = new ArrayList<IConfigEntry>();
        for (IConfigElement configElement : parent.configElements) {
            int length;
            if (configElement == null || !configElement.isProperty() || !configElement.showInGui() || (length = !cey.a((String)configElement.getLanguageKey(), (Object[])new Object[0]).equals(configElement.getLanguageKey()) ? mc.k.a(cey.a((String)configElement.getLanguageKey(), (Object[])new Object[0])) : mc.k.a(configElement.getName())) <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = length;
        }
        int viewWidth = this.maxLabelTextWidth + 8 + this.b / 2;
        this.labelX = this.b / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.b / 2 + viewWidth / 2 - 45;
        this.controlWidth = this.resetX - this.controlX - 5;
        this.scrollBarX = this.b;
        for (IConfigElement configElement : parent.configElements) {
            if (configElement == null || !configElement.showInGui()) continue;
            if (configElement.getConfigEntryClass() != null) {
                try {
                    this.listEntries.add(configElement.getConfigEntryClass().getConstructor(GuiConfig.class, GuiConfigEntries.class, IConfigElement.class).newInstance(new Object[]{this.owningScreen, this, configElement}));
                }
                catch (Throwable e) {
                    FMLLog.log.error("There was a critical error instantiating the custom IConfigEntry for config element {}.", (Object)configElement.getName(), (Object)e);
                }
                continue;
            }
            if (configElement.isProperty()) {
                if (configElement.isList()) {
                    this.listEntries.add(new ArrayEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.BOOLEAN) {
                    this.listEntries.add(new BooleanEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.INTEGER) {
                    if (configElement.hasSlidingControl()) {
                        this.listEntries.add(new NumberSliderEntry(this.owningScreen, this, configElement));
                        continue;
                    }
                    this.listEntries.add(new IntegerEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.DOUBLE) {
                    if (configElement.hasSlidingControl()) {
                        this.listEntries.add(new NumberSliderEntry(this.owningScreen, this, configElement));
                        continue;
                    }
                    this.listEntries.add(new DoubleEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.COLOR) {
                    if (configElement.getValidValues() != null && configElement.getValidValues().length > 0) {
                        this.listEntries.add(new ChatColorEntry(this.owningScreen, this, configElement));
                        continue;
                    }
                    this.listEntries.add(new StringEntry(this.owningScreen, this, configElement));
                    continue;
                }
                if (configElement.getType() == ConfigGuiType.MOD_ID) {
                    TreeMap<Object, String> values = new TreeMap<Object, String>();
                    for (ModContainer mod : Loader.instance().getActiveModList()) {
                        values.put(mod.getModId(), mod.getName());
                    }
                    values.put("minecraft", "Minecraft");
                    this.listEntries.add(new SelectValueEntry(this.owningScreen, this, configElement, values));
                    continue;
                }
                if (configElement.getType() != ConfigGuiType.STRING) continue;
                if (configElement.getValidValues() != null && configElement.getValidValues().length > 0) {
                    this.listEntries.add(new CycleValueEntry(this.owningScreen, this, configElement));
                    continue;
                }
                this.listEntries.add(new StringEntry(this.owningScreen, this, configElement));
                continue;
            }
            if (configElement.getType() != ConfigGuiType.CONFIG_CATEGORY) continue;
            this.listEntries.add(new CategoryEntry(this.owningScreen, this, configElement));
        }
    }

    protected void initGui() {
        this.b = this.owningScreen.l;
        this.c = this.owningScreen.m;
        this.maxLabelTextWidth = 0;
        for (IConfigEntry entry : this.listEntries) {
            if (entry.getLabelWidth() <= this.maxLabelTextWidth) continue;
            this.maxLabelTextWidth = entry.getLabelWidth();
        }
        this.d = this.owningScreen.titleLine2 != null ? 33 : 23;
        this.e = this.owningScreen.m - 32;
        this.g = 0;
        this.f = this.b;
        int viewWidth = this.maxLabelTextWidth + 8 + this.b / 2;
        this.labelX = this.b / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.b / 2 + viewWidth / 2 - 45;
        this.maxEntryRightBound = 0;
        for (IConfigEntry entry : this.listEntries) {
            if (entry.getEntryRightBound() <= this.maxEntryRightBound) continue;
            this.maxEntryRightBound = entry.getEntryRightBound();
        }
        this.scrollBarX = this.maxEntryRightBound + 5;
        this.controlWidth = this.maxEntryRightBound - this.controlX - 45;
    }

    public int b() {
        return this.listEntries.size();
    }

    public IConfigEntry getListEntry(int index) {
        return this.listEntries.get(index);
    }

    public int d() {
        return this.scrollBarX;
    }

    public int c() {
        return this.owningScreen.l;
    }

    public void keyTyped(char eventChar, int eventKey) {
        for (IConfigEntry entry : this.listEntries) {
            entry.keyTyped(eventChar, eventKey);
        }
    }

    public void updateScreen() {
        for (IConfigEntry entry : this.listEntries) {
            entry.updateCursorCounter();
        }
    }

    public void mouseClickedPassThru(int mouseX, int mouseY, int mouseEvent) {
        for (IConfigEntry entry : this.listEntries) {
            entry.mouseClicked(mouseX, mouseY, mouseEvent);
        }
    }

    public void onGuiClosed() {
        for (IConfigEntry entry : this.listEntries) {
            entry.onGuiClosed();
        }
    }

    public boolean saveConfigElements() {
        boolean requiresRestart = false;
        for (IConfigEntry entry : this.listEntries) {
            if (!entry.saveConfigElement()) continue;
            requiresRestart = true;
        }
        return requiresRestart;
    }

    public boolean areAllEntriesDefault(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || entry.isDefault()) continue;
            return false;
        }
        return true;
    }

    public void setAllToDefault(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry) continue;
            entry.setToDefault();
        }
    }

    public boolean hasChangedEntry(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || !entry.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean areAnyEntriesEnabled(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry || !entry.enabled()) continue;
            return true;
        }
        return false;
    }

    public void undoAllChanges(boolean includeChildren) {
        for (IConfigEntry entry : this.listEntries) {
            if (!includeChildren && entry instanceof CategoryEntry) continue;
            entry.undoChanges();
        }
    }

    public void drawScreenPost(int mouseX, int mouseY, float partialTicks) {
        for (IConfigEntry entry : this.listEntries) {
            entry.drawToolTip(mouseX, mouseY);
        }
    }

    public static interface IConfigEntry
    extends bjm.a {
        public IConfigElement getConfigElement();

        public String getName();

        public Object getCurrentValue();

        public Object[] getCurrentValues();

        public boolean enabled();

        public void keyTyped(char var1, int var2);

        public void updateCursorCounter();

        public void mouseClicked(int var1, int var2, int var3);

        public boolean isDefault();

        public void setToDefault();

        public void undoChanges();

        public boolean isChanged();

        public boolean saveConfigElement();

        public void drawToolTip(int var1, int var2);

        public int getLabelWidth();

        public int getEntryRightBound();

        public void onGuiClosed();
    }

    public static abstract class ListEntryBase
    implements IConfigEntry {
        protected final GuiConfig owningScreen;
        protected final GuiConfigEntries owningEntryList;
        protected final IConfigElement configElement;
        protected final bib mc;
        protected final String name;
        protected final GuiButtonExt btnUndoChanges;
        protected final GuiButtonExt btnDefault;
        protected List<String> toolTip;
        protected List<String> undoToolTip;
        protected List<String> defaultToolTip;
        protected boolean isValidValue = true;
        protected HoverChecker tooltipHoverChecker;
        protected HoverChecker undoHoverChecker;
        protected HoverChecker defaultHoverChecker;
        protected boolean drawLabel;

        public ListEntryBase(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            this.owningScreen = owningScreen;
            this.owningEntryList = owningEntryList;
            this.configElement = configElement;
            this.mc = bib.z();
            String trans = cey.a((String)configElement.getLanguageKey(), (Object[])new Object[0]);
            this.name = !trans.equals(configElement.getLanguageKey()) ? trans : configElement.getName();
            this.btnUndoChanges = new GuiButtonExt(0, 0, 0, 18, 18, "\u21b6");
            this.btnDefault = new GuiButtonExt(0, 0, 0, 18, 18, "\u2604");
            this.undoHoverChecker = new HoverChecker(this.btnUndoChanges, 800);
            this.defaultHoverChecker = new HoverChecker(this.btnDefault, 800);
            this.undoToolTip = Arrays.asList(cey.a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]));
            this.defaultToolTip = Arrays.asList(cey.a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]));
            this.toolTip = new ArrayList<String>();
            this.drawLabel = true;
            String comment = cey.a((String)(configElement.getLanguageKey() + ".tooltip"), (Object[])new Object[0]).replace("\\n", "\n");
            if (!comment.equals(configElement.getLanguageKey() + ".tooltip")) {
                Collections.addAll(this.toolTip, (a.k + this.name + "\n" + a.o + this.removeTag(comment, "[default:", "]")).split("\n"));
            } else if (configElement.getComment() != null && !configElement.getComment().trim().isEmpty()) {
                Collections.addAll(this.toolTip, (a.k + this.name + "\n" + a.o + this.removeTag(configElement.getComment(), "[default:", "]")).split("\n"));
            } else {
                Collections.addAll(this.toolTip, (a.k + this.name + "\n" + a.m + "No tooltip defined.").split("\n"));
            }
            if (configElement.getType() == ConfigGuiType.INTEGER && (Integer.valueOf(configElement.getMinValue().toString()) != Integer.MIN_VALUE || Integer.valueOf(configElement.getMaxValue().toString()) != Integer.MAX_VALUE) || configElement.getType() == ConfigGuiType.DOUBLE && (Double.valueOf(configElement.getMinValue().toString()) != -1.7976931348623157E308 || Double.valueOf(configElement.getMaxValue().toString()) != Double.MAX_VALUE)) {
                Collections.addAll(this.toolTip, (a.l + cey.a((String)"fml.configgui.tooltip.defaultNumeric", (Object[])new Object[]{configElement.getMinValue(), configElement.getMaxValue(), configElement.getDefault()})).split("\n"));
            } else if (configElement.getType() != ConfigGuiType.CONFIG_CATEGORY) {
                Collections.addAll(this.toolTip, (a.l + cey.a((String)"fml.configgui.tooltip.default", (Object[])new Object[]{configElement.getDefault()})).split("\n"));
            }
            if (configElement.requiresMcRestart() || owningScreen.allRequireMcRestart) {
                this.toolTip.add(a.m + "[" + cey.a((String)"fml.configgui.gameRestartTitle", (Object[])new Object[0]) + "]");
            }
        }

        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            boolean isChanged = this.isChanged();
            if (this.drawLabel) {
                String label = (!this.isValidValue ? a.m.toString() : (isChanged ? a.p.toString() : a.h.toString())) + (isChanged ? a.u.toString() : "") + this.name;
                this.mc.k.a(label, this.owningScreen.entryList.labelX, y + slotHeight / 2 - this.mc.k.a / 2, 0xFFFFFF);
            }
            this.btnUndoChanges.h = this.owningEntryList.scrollBarX - 44;
            this.btnUndoChanges.i = y;
            this.btnUndoChanges.l = this.enabled() && isChanged;
            this.btnUndoChanges.a(this.mc, mouseX, mouseY, partial);
            this.btnDefault.h = this.owningEntryList.scrollBarX - 22;
            this.btnDefault.i = y;
            this.btnDefault.l = this.enabled() && !this.isDefault();
            this.btnDefault.a(this.mc, mouseX, mouseY, partial);
            if (this.tooltipHoverChecker == null) {
                this.tooltipHoverChecker = new HoverChecker(y, y + slotHeight, x, this.owningScreen.entryList.controlX - 8, 800);
            } else {
                this.tooltipHoverChecker.updateBounds(y, y + slotHeight, x, this.owningScreen.entryList.controlX - 8);
            }
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningScreen.entryList.e && mouseY > this.owningScreen.entryList.d;
            if (this.toolTip != null && this.tooltipHoverChecker != null && this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            if (this.undoHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.undoToolTip, mouseX, mouseY);
            }
            if (this.defaultHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.defaultToolTip, mouseX, mouseY);
            }
        }

        public boolean a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnDefault.b(this.mc, x, y)) {
                this.btnDefault.a(this.mc.U());
                this.setToDefault();
                return true;
            }
            if (this.btnUndoChanges.b(this.mc, x, y)) {
                this.btnUndoChanges.a(this.mc.U());
                this.undoChanges();
                return true;
            }
            return false;
        }

        public void b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnDefault.a(x, y);
        }

        @Override
        public abstract boolean isDefault();

        @Override
        public abstract void setToDefault();

        @Override
        public abstract void keyTyped(char var1, int var2);

        @Override
        public abstract void updateCursorCounter();

        @Override
        public abstract void mouseClicked(int var1, int var2, int var3);

        @Override
        public abstract boolean isChanged();

        @Override
        public abstract void undoChanges();

        @Override
        public abstract boolean saveConfigElement();

        public void a(int p_178011_1_, int p_178011_2_, int p_178011_3_, float partial) {
        }

        @Override
        public boolean enabled() {
            return this.owningScreen.isWorldRunning ? !this.owningScreen.allRequireWorldRestart && !this.configElement.requiresWorldRestart() : true;
        }

        @Override
        public int getLabelWidth() {
            return this.mc.k.a(this.name);
        }

        @Override
        public int getEntryRightBound() {
            return this.owningEntryList.resetX + 40;
        }

        @Override
        public IConfigElement getConfigElement() {
            return this.configElement;
        }

        @Override
        public String getName() {
            return this.configElement.getName();
        }

        @Override
        public abstract Object getCurrentValue();

        @Override
        public abstract Object[] getCurrentValues();

        @Override
        public void onGuiClosed() {
        }

        private String removeTag(String target, String tagStart, String tagEnd) {
            int tagStartPosition = target.indexOf(tagStart);
            int tagEndPosition = target.indexOf(tagEnd, tagStartPosition + tagStart.length());
            if (-1 == tagStartPosition || -1 == tagEndPosition) {
                return target;
            }
            String taglessResult = target.substring(0, tagStartPosition);
            taglessResult = taglessResult + target.substring(tagEndPosition + 1, target.length());
            return taglessResult;
        }
    }

    public static class CategoryEntry
    extends ListEntryBase {
        protected blk childScreen = this.buildChildScreen();
        protected final GuiButtonExt btnSelectCategory = new GuiButtonExt(0, 0, 0, 300, 18, cey.a((String)this.name, (Object[])new Object[0]));

        public CategoryEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.tooltipHoverChecker = new HoverChecker(this.btnSelectCategory, 800);
            this.drawLabel = false;
        }

        protected blk buildChildScreen() {
            return new GuiConfig((blk)this.owningScreen, this.configElement.getChildElements(), this.owningScreen.modID, this.owningScreen.allRequireWorldRestart || this.configElement.requiresWorldRestart(), this.owningScreen.allRequireMcRestart || this.configElement.requiresMcRestart(), this.owningScreen.title, (this.owningScreen.titleLine2 == null ? "" : this.owningScreen.titleLine2) + " > " + this.name);
        }

        @Override
        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            this.btnSelectCategory.h = listWidth / 2 - 150;
            this.btnSelectCategory.i = y;
            this.btnSelectCategory.l = this.enabled();
            this.btnSelectCategory.a(this.mc, mouseX, mouseY, partial);
            super.a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            boolean canHover;
            boolean bl = canHover = mouseY < this.owningScreen.entryList.e && mouseY > this.owningScreen.entryList.d;
            if (this.tooltipHoverChecker.checkHover(mouseX, mouseY, canHover)) {
                this.owningScreen.drawToolTip(this.toolTip, mouseX, mouseY);
            }
            super.drawToolTip(mouseX, mouseY);
        }

        @Override
        public boolean a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnSelectCategory.b(this.mc, x, y)) {
                this.btnSelectCategory.a(this.mc.U());
                bib.z().a(this.childScreen);
                return true;
            }
            return super.a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnSelectCategory.a(x, y);
        }

        @Override
        public boolean isDefault() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                return ((GuiConfig)this.childScreen).entryList.areAllEntriesDefault(true);
            }
            return true;
        }

        @Override
        public void setToDefault() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                ((GuiConfig)this.childScreen).entryList.setAllToDefault(true);
            }
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public boolean saveConfigElement() {
            boolean requiresRestart = false;
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                boolean bl = requiresRestart = this.configElement.requiresMcRestart() && ((GuiConfig)this.childScreen).entryList.hasChangedEntry(true);
                if (((GuiConfig)this.childScreen).entryList.saveConfigElements()) {
                    requiresRestart = true;
                }
            }
            return requiresRestart;
        }

        @Override
        public boolean isChanged() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                return ((GuiConfig)this.childScreen).entryList.hasChangedEntry(true);
            }
            return false;
        }

        @Override
        public void undoChanges() {
            if (this.childScreen instanceof GuiConfig && ((GuiConfig)this.childScreen).entryList != null) {
                ((GuiConfig)this.childScreen).entryList.undoAllChanges(true);
            }
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public int getLabelWidth() {
            return 0;
        }

        @Override
        public int getEntryRightBound() {
            return this.owningEntryList.b / 2 + 155 + 22 + 18;
        }

        @Override
        public String getCurrentValue() {
            return "";
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class StringEntry
    extends ListEntryBase {
        protected final bje textFieldValue;
        protected final String beforeValue;

        public StringEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = configElement.get().toString();
            this.textFieldValue = new bje(10, this.mc.k, this.owningEntryList.controlX + 1, 0, this.owningEntryList.controlWidth - 3, 16);
            this.textFieldValue.f(10000);
            this.textFieldValue.a(configElement.get().toString());
        }

        @Override
        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.textFieldValue.a = this.owningEntryList.controlX + 2;
            this.textFieldValue.f = y + 1;
            this.textFieldValue.i = this.owningEntryList.controlWidth - 4;
            this.textFieldValue.c(this.enabled());
            this.textFieldValue.g();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                this.textFieldValue.a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                if (this.configElement.getValidationPattern() != null) {
                    this.isValidValue = this.configElement.getValidationPattern().matcher(this.textFieldValue.b().trim()).matches();
                }
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.a();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.a(x, y, mouseEvent);
        }

        @Override
        public boolean isDefault() {
            return this.configElement.getDefault() != null ? this.configElement.getDefault().toString().equals(this.textFieldValue.b()) : this.textFieldValue.b().trim().isEmpty();
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.textFieldValue.a(this.configElement.getDefault().toString());
                this.keyTyped('\u0000', 199);
            }
        }

        @Override
        public boolean isChanged() {
            return this.beforeValue != null ? !this.beforeValue.equals(this.textFieldValue.b()) : this.textFieldValue.b().trim().isEmpty();
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.a(this.beforeValue);
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    this.configElement.set(this.textFieldValue.b());
                    return this.configElement.requiresMcRestart();
                }
                if (this.isChanged() && !this.isValidValue) {
                    this.configElement.setToDefault();
                    return this.configElement.requiresMcRestart() && this.beforeValue != null ? this.beforeValue.equals(this.configElement.getDefault()) : this.configElement.getDefault() == null;
                }
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            return this.textFieldValue.b();
        }

        @Override
        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }
    }

    public static class DoubleEntry
    extends StringEntry {
        protected final double beforeValue;

        public DoubleEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = Double.valueOf(configElement.get().toString());
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.i() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.b().trim().isEmpty() && !this.textFieldValue.b().trim().equals("-")) {
                        try {
                            double value = Double.parseDouble(this.textFieldValue.b().trim());
                            if (value < Double.valueOf(this.configElement.getMinValue().toString()) || value > Double.valueOf(this.configElement.getMaxValue().toString())) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Double.parseDouble(this.textFieldValue.b().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.a(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.b().trim());
                        this.configElement.set(value);
                        return this.configElement.requiresMcRestart();
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.b().trim());
                        if (value < Double.valueOf(this.configElement.getMinValue().toString())) {
                            this.configElement.set(this.configElement.getMinValue());
                        } else {
                            this.configElement.set(this.configElement.getMaxValue());
                        }
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                }
                return this.configElement.requiresMcRestart() && this.beforeValue != Double.parseDouble(this.configElement.get().toString());
            }
            return false;
        }
    }

    public static class IntegerEntry
    extends StringEntry {
        protected final int beforeValue;

        public IntegerEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = Integer.valueOf(configElement.get().toString());
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block7: {
                if (this.enabled() || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    String validChars = "0123456789";
                    String before = this.textFieldValue.b();
                    if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.i() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                        this.textFieldValue.a(this.enabled() ? eventChar : (char)'\u0000', eventKey);
                    }
                    if (!this.textFieldValue.b().trim().isEmpty() && !this.textFieldValue.b().trim().equals("-")) {
                        try {
                            long value = Long.parseLong(this.textFieldValue.b().trim());
                            if (value < (long)Integer.valueOf(this.configElement.getMinValue().toString()).intValue() || value > (long)Integer.valueOf(this.configElement.getMaxValue().toString()).intValue()) {
                                this.isValidValue = false;
                                break block7;
                            }
                            this.isValidValue = true;
                        }
                        catch (Throwable e) {
                            this.isValidValue = false;
                        }
                    } else {
                        this.isValidValue = false;
                    }
                }
            }
        }

        @Override
        public boolean isChanged() {
            try {
                return this.beforeValue != Integer.parseInt(this.textFieldValue.b().trim());
            }
            catch (Throwable e) {
                return true;
            }
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.textFieldValue.a(String.valueOf(this.beforeValue));
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled()) {
                if (this.isChanged() && this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.b().trim());
                        this.configElement.set(value);
                        return this.configElement.requiresMcRestart();
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                } else if (this.isChanged() && !this.isValidValue) {
                    try {
                        int value = Integer.parseInt(this.textFieldValue.b().trim());
                        if (value < Integer.valueOf(this.configElement.getMinValue().toString())) {
                            this.configElement.set(this.configElement.getMinValue());
                        } else {
                            this.configElement.set(this.configElement.getMaxValue());
                        }
                    }
                    catch (Throwable e) {
                        this.configElement.setToDefault();
                    }
                }
                return this.configElement.requiresMcRestart() && this.beforeValue != Integer.parseInt(this.configElement.get().toString());
            }
            return false;
        }
    }

    public static abstract class ButtonEntry
    extends ListEntryBase {
        protected final GuiButtonExt btnValue;

        public ButtonEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            this(owningScreen, owningEntryList, configElement, new GuiButtonExt(0, owningEntryList.controlX, 0, owningEntryList.controlWidth, 18, configElement.get() != null ? cey.a((String)String.valueOf(configElement.get()), (Object[])new Object[0]) : ""));
        }

        public ButtonEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement, GuiButtonExt button) {
            super(owningScreen, owningEntryList, configElement);
            this.btnValue = button;
        }

        public abstract void updateValueButtonText();

        public abstract void valueButtonPressed(int var1);

        @Override
        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            super.a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
            this.btnValue.f = this.owningEntryList.controlWidth;
            this.btnValue.h = this.owningScreen.entryList.controlX;
            this.btnValue.i = y;
            this.btnValue.l = this.enabled();
            this.btnValue.a(this.mc, mouseX, mouseY, partial);
        }

        @Override
        public boolean a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.b(this.mc, x, y)) {
                this.btnValue.a(this.mc.U());
                this.valueButtonPressed(index);
                this.updateValueButtonText();
                return true;
            }
            return super.a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            super.b(index, x, y, mouseEvent, relativeX, relativeY);
            this.btnValue.a(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }
    }

    public static class NumberSliderEntry
    extends ButtonEntry {
        protected final double beforeValue;

        public NumberSliderEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement, new GuiSlider(0, owningEntryList.controlX, 0, owningEntryList.controlWidth, 18, "", "", Double.valueOf(configElement.getMinValue().toString()), Double.valueOf(configElement.getMaxValue().toString()), Double.valueOf(configElement.get().toString()), configElement.getType() == ConfigGuiType.DOUBLE, true));
            this.beforeValue = configElement.getType() == ConfigGuiType.INTEGER ? (double)Integer.valueOf(configElement.get().toString()).intValue() : Double.valueOf(configElement.get().toString());
        }

        @Override
        public void updateValueButtonText() {
            ((GuiSlider)this.btnValue).updateSlider();
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
        }

        @Override
        public boolean isDefault() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() == Integer.valueOf(this.configElement.getDefault().toString()).intValue();
            }
            return ((GuiSlider)this.btnValue).getValue() == Double.valueOf(this.configElement.getDefault().toString()).doubleValue();
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(Double.valueOf(this.configElement.getDefault().toString()));
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        @Override
        public boolean isChanged() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt() != (int)Math.round(this.beforeValue);
            }
            return ((GuiSlider)this.btnValue).getValue() != this.beforeValue;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                ((GuiSlider)this.btnValue).setValue(this.beforeValue);
                ((GuiSlider)this.btnValue).updateSlider();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                    this.configElement.set(((GuiSlider)this.btnValue).getValueInt());
                } else {
                    this.configElement.set(((GuiSlider)this.btnValue).getValue());
                }
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            if (this.configElement.getType() == ConfigGuiType.INTEGER) {
                return ((GuiSlider)this.btnValue).getValueInt();
            }
            return ((GuiSlider)this.btnValue).getValue();
        }

        @Override
        public Object[] getCurrentValues() {
            return new Object[]{this.getCurrentValue()};
        }
    }

    public static class ArrayEntry
    extends ButtonEntry {
        protected final Object[] beforeValues;
        protected Object[] currentValues;

        public ArrayEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValues = configElement.getList();
            this.currentValues = configElement.getList();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.j = "";
            for (Object o : this.currentValues) {
                this.btnValue.j = this.btnValue.j + ", [" + o + "]";
            }
            this.btnValue.j = this.btnValue.j.replaceFirst(", ", "");
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.a((blk)new GuiEditArray(this.owningScreen, this.configElement, slotIndex, this.currentValues, this.enabled()));
        }

        public void setListFromChildScreen(Object[] newList) {
            if (this.enabled() && !Arrays.deepEquals(this.currentValues, newList)) {
                this.currentValues = newList;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return Arrays.deepEquals(this.configElement.getDefaults(), this.currentValues);
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValues = this.configElement.getDefaults();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return !Arrays.deepEquals(this.beforeValues, this.currentValues);
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValues = this.beforeValues;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValues);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Object getCurrentValue() {
            return this.btnValue.j;
        }

        @Override
        public Object[] getCurrentValues() {
            return this.currentValues;
        }
    }

    public static class SelectValueEntry
    extends ButtonEntry {
        protected final String beforeValue;
        protected Object currentValue;
        protected Map<Object, String> selectableValues;

        public SelectValueEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement, Map<Object, String> selectableValues) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeValue = configElement.get().toString();
            this.currentValue = configElement.get().toString();
            this.selectableValues = selectableValues;
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.j = this.currentValue.toString();
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            this.mc.a((blk)new GuiSelectString(this.owningScreen, this.configElement, slotIndex, this.selectableValues, this.currentValue, this.enabled()));
        }

        public void setValueFromChildScreen(Object newValue) {
            if (this.enabled() && this.currentValue != null ? !this.currentValue.equals(newValue) : newValue != null) {
                this.currentValue = newValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            if (this.configElement.getDefault() != null) {
                return this.configElement.getDefault().equals(this.currentValue);
            }
            return this.currentValue == null;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = this.configElement.getDefault().toString();
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            if (this.beforeValue != null) {
                return !this.beforeValue.equals(this.currentValue);
            }
            return this.currentValue == null;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public String getCurrentValue() {
            return this.currentValue.toString();
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class ChatColorEntry
    extends CycleValueEntry {
        ChatColorEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.btnValue.l = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partial) {
            this.btnValue.packedFGColour = GuiUtils.getColorCode(this.getValidValueDisplay().charAt(0), true);
            super.a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partial);
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.j = cey.a((String)this.getValidValueDisplay(), (Object[])new Object[0]) + " - " + cey.a((String)"fml.configgui.sampletext", (Object[])new Object[0]);
        }
    }

    public static class CycleValueEntry
    extends ButtonEntry {
        protected final int beforeIndex;
        protected final int defaultIndex;
        protected int currentIndex;

        private CycleValueEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.beforeIndex = this.getIndex(configElement.get().toString());
            this.defaultIndex = this.getIndex(configElement.getDefault().toString());
            this.currentIndex = this.beforeIndex;
            this.btnValue.l = this.enabled();
            this.updateValueButtonText();
        }

        private int getIndex(String s) {
            for (int i2 = 0; i2 < this.configElement.getValidValues().length; ++i2) {
                if (!this.configElement.getValidValues()[i2].equalsIgnoreCase(s)) continue;
                return i2;
            }
            return 0;
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.j = cey.a((String)this.getValidValueDisplay(), (Object[])new Object[0]);
        }

        protected String getValidValueDisplay() {
            String[] validValuesDisplay = this.configElement.getValidValuesDisplay();
            return validValuesDisplay != null && validValuesDisplay.length > 0 ? validValuesDisplay[this.currentIndex] : this.configElement.getValidValues()[this.currentIndex];
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                if (++this.currentIndex >= this.configElement.getValidValues().length) {
                    this.currentIndex = 0;
                }
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentIndex == this.defaultIndex;
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentIndex = this.defaultIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentIndex != this.beforeIndex;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentIndex = this.beforeIndex;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.configElement.getValidValues()[this.currentIndex]);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public String getCurrentValue() {
            return this.configElement.getValidValues()[this.currentIndex];
        }

        public String[] getCurrentValues() {
            return new String[]{this.getCurrentValue()};
        }
    }

    public static class BooleanEntry
    extends ButtonEntry {
        protected final boolean beforeValue;
        protected boolean currentValue;

        private BooleanEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
            this.currentValue = this.beforeValue = Boolean.valueOf(configElement.get().toString()).booleanValue();
            this.btnValue.l = this.enabled();
            this.updateValueButtonText();
        }

        @Override
        public void updateValueButtonText() {
            this.btnValue.j = cey.a((String)String.valueOf(this.currentValue), (Object[])new Object[0]);
            this.btnValue.packedFGColour = this.currentValue ? GuiUtils.getColorCode('2', true) : GuiUtils.getColorCode('4', true);
        }

        @Override
        public void valueButtonPressed(int slotIndex) {
            if (this.enabled()) {
                this.currentValue = !this.currentValue;
            }
        }

        @Override
        public boolean isDefault() {
            return this.currentValue == Boolean.valueOf(this.configElement.getDefault().toString());
        }

        @Override
        public void setToDefault() {
            if (this.enabled()) {
                this.currentValue = Boolean.valueOf(this.configElement.getDefault().toString());
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean isChanged() {
            return this.currentValue != this.beforeValue;
        }

        @Override
        public void undoChanges() {
            if (this.enabled()) {
                this.currentValue = this.beforeValue;
                this.updateValueButtonText();
            }
        }

        @Override
        public boolean saveConfigElement() {
            if (this.enabled() && this.isChanged()) {
                this.configElement.set(this.currentValue);
                return this.configElement.requiresMcRestart();
            }
            return false;
        }

        @Override
        public Boolean getCurrentValue() {
            return this.currentValue;
        }

        public Boolean[] getCurrentValues() {
            return new Boolean[]{this.getCurrentValue()};
        }
    }
}

