/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.block;

import appeng.util.Platform;
import io.github.phantamanta44.libnine.block.L9BlockStated;
import io.github.phantamanta44.libnine.gui.GuiIdentity;
import io.github.phantamanta44.libnine.item.L9ItemBlock;
import io.github.phantamanta44.libnine.tile.L9TileEntity;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.world.WorldBlockPos;
import io.github.phantamanta44.libnine.util.world.WorldUtils;
import io.github.phantamanta44.threng.ThrEng;
import io.github.phantamanta44.threng.block.ThrEngBlocks;
import io.github.phantamanta44.threng.block.ThrEngProps;
import io.github.phantamanta44.threng.inventory.ThrEngGuis;
import io.github.phantamanta44.threng.item.block.ItemBlockMachine;
import io.github.phantamanta44.threng.tile.TileAggregator;
import io.github.phantamanta44.threng.tile.TileCentrifuge;
import io.github.phantamanta44.threng.tile.TileEnergizer;
import io.github.phantamanta44.threng.tile.TileEtcher;
import io.github.phantamanta44.threng.tile.TileFastCraftingBus;
import io.github.phantamanta44.threng.tile.TileLevelMaintainer;
import io.github.phantamanta44.threng.tile.base.IActivable;
import io.github.phantamanta44.threng.tile.base.IDirectionable;
import io.github.phantamanta44.threng.tile.base.IDroppableInventory;
import io.github.phantamanta44.threng.tile.base.TileAENetworked;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMachine
extends L9BlockStated {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);

    public BlockMachine() {
        super("machine", Material.field_151573_f);
        this.func_149711_c(6.0f);
        this.setTileFactory((w, m) -> Type.fromMeta(m).createTile());
    }

    protected L9ItemBlock initItemBlock() {
        return new ItemBlockMachine(this);
    }

    protected void accrueProperties(Accrue<IProperty<?>> props) {
        props.accept(TYPE);
    }

    protected void accrueVolatileProperties(Accrue<IProperty<?>> props) {
        props.acceptAll((Object[])new IProperty[]{ThrEngProps.ACTIVE, ThrEngProps.ROTATION});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = Objects.requireNonNull(world.func_175625_s(pos));
        return state.func_177226_a((IProperty)ThrEngProps.ACTIVE, (Comparable)Boolean.valueOf(((IActivable)tile).isActive())).func_177226_a(ThrEngProps.ROTATION, (Comparable)((IDirectionable)tile).getFrontFace());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = Objects.requireNonNull(this.getTileEntity((IBlockAccess)world, pos));
        if (tile instanceof IDirectionable) {
            ((IDirectionable)tile).setFrontFace(placer.func_174811_aO().func_176734_d());
        }
        if (tile instanceof TileAENetworked && placer instanceof EntityPlayer) {
            ((TileAENetworked)tile).getProxy().setOwner((EntityPlayer)placer);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack held;
            if (player.func_70093_af() && Platform.isWrench((EntityPlayer)player, (ItemStack)(held = player.func_184586_b(hand)), (BlockPos)pos)) {
                this.func_176226_b(world, pos, state, 0);
                world.func_175698_g(pos);
                return true;
            }
            ThrEng.INSTANCE.getGuiHandler().openGui(player, ((Type)((Object)state.func_177229_b(BlockMachine.TYPE))).gui, new WorldBlockPos(world, pos));
        }
        return true;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tileUnchecked = Objects.requireNonNull(this.getTileEntity((IBlockAccess)world, pos));
        if (!(tileUnchecked instanceof IDirectionable)) {
            return false;
        }
        IDirectionable tile = (IDirectionable)tileUnchecked;
        if (axis == EnumFacing.UP) {
            tile.setFrontFace(tile.getFrontFace().func_176746_e());
        } else if (axis == EnumFacing.DOWN) {
            tile.setFrontFace(tile.getFrontFace().func_176735_f());
        } else {
            EnumFacing current = tile.getFrontFace();
            tile.setFrontFace(axis == current ? current.func_176734_d() : axis);
        }
        return true;
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return EnumFacing.field_176754_o;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tile = this.getTileEntity((IBlockAccess)world, pos);
        if (tile instanceof IDroppableInventory) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            ((IDroppableInventory)tile).collectDrops((Accrue<ItemStack>)new Accrue(drops));
            drops.forEach(stack -> WorldUtils.dropItem((World)world, (BlockPos)pos, (ItemStack)stack));
        }
        super.func_180663_b(world, pos, state);
    }

    public static enum Type implements IStringSerializable
    {
        AGGREGATOR(TileAggregator::new, ThrEngGuis.AGGREGATOR),
        CENTRIFUGE(TileCentrifuge::new, ThrEngGuis.CENTRIFUGE),
        ETCHER(TileEtcher::new, ThrEngGuis.ETCHER),
        FAST_CRAFTER(TileFastCraftingBus::new, ThrEngGuis.FAST_CRAFTER),
        LEVEL_MAINTAINER(TileLevelMaintainer::new, ThrEngGuis.LEVEL_MAINTAINER),
        ENERGIZER(TileEnergizer::new, ThrEngGuis.ENERGIZER);

        public final GuiIdentity<?, ?> gui;
        private final Supplier<? extends L9TileEntity> factory;

        private Type(Supplier<? extends L9TileEntity> factory, GuiIdentity<?, ?> gui) {
            this.factory = factory;
            this.gui = gui;
        }

        public TileEntity createTile() {
            return (TileEntity)this.factory.get();
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public static Type fromMeta(int meta) {
            return Type.values()[meta];
        }

        public ItemStack newStack(int count) {
            return new ItemStack((Block)ThrEngBlocks.MACHINE, count, this.ordinal());
        }
    }
}

