/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile;

import io.github.phantamanta44.libnine.capability.impl.L9AspectSlot;
import io.github.phantamanta44.libnine.capability.provider.CapabilityBrokerDirPredicated;
import io.github.phantamanta44.libnine.recipe.output.ItemStackOutput;
import io.github.phantamanta44.libnine.tile.RegisterTile;
import io.github.phantamanta44.libnine.util.collection.Accrue;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.helper.InventoryUtils;
import io.github.phantamanta44.libnine.util.tuple.IPair;
import io.github.phantamanta44.libnine.util.world.IAllocableSides;
import io.github.phantamanta44.libnine.util.world.SideAlloc;
import io.github.phantamanta44.threng.ThrEngConfig;
import io.github.phantamanta44.threng.recipe.EnergizeRecipe;
import io.github.phantamanta44.threng.recipe.component.ItemEnergyInput;
import io.github.phantamanta44.threng.tile.base.TileSimpleProcessor;
import io.github.phantamanta44.threng.util.ConjoinedItemHandler;
import io.github.phantamanta44.threng.util.InsertOnlyItemHandler;
import io.github.phantamanta44.threng.util.SlotType;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

@RegisterTile(value="threng")
public class TileEnergizer
extends TileSimpleProcessor<IPair<ItemStack, Integer>, ItemStack, ItemEnergyInput, ItemStackOutput, EnergizeRecipe> {
    @AutoSerialize(sync=false)
    private final L9AspectSlot slotInput = new L9AspectSlot.Observable((s, o, n) -> this.markWorkStateDirty());
    @AutoSerialize(sync=false)
    private final L9AspectSlot slotOutput = new L9AspectSlot.Observable(is -> false, (s, o, n) -> this.markWorkStateDirty());
    @AutoSerialize
    private final SideAlloc<SlotType.BasicIO> sides = new SideAlloc((Enum)SlotType.BasicIO.NONE, this::getFrontFace);

    public TileEnergizer() {
        super(EnergizeRecipe.class, ThrEngConfig.processing.energizerEnergyBuffer);
        this.setInitialized();
    }

    @Override
    protected CapabilityBrokerDirPredicated initCapabilities() {
        InsertOnlyItemHandler inputs = new InsertOnlyItemHandler((IItemHandler)this.slotInput);
        return super.initCapabilities().with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)inputs, this.sides.getPredicate((Enum)SlotType.BasicIO.INPUT)).with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)this.slotOutput, this.sides.getPredicate((Enum)SlotType.BasicIO.OUTPUT)).with(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Object)new ConjoinedItemHandler(new IItemHandler[]{inputs, this.slotOutput}), this.sides.getPredicate((Enum)SlotType.BasicIO.OMNI));
    }

    @Override
    public IAllocableSides<SlotType.BasicIO> getSidedIo() {
        return this.sides;
    }

    @Override
    protected int getBaseEnergyPerOperation() {
        EnergizeRecipe recipe = (EnergizeRecipe)this.getActiveRecipe();
        return recipe != null ? recipe.input().getEnergy() : 8100;
    }

    @Override
    protected int getUpgradeEnergyCost() {
        return ThrEngConfig.processing.energizerEnergyCostUpgrade * this.getUpgradeCount();
    }

    @Override
    protected int getBaseMaxWork() {
        return ThrEngConfig.processing.energizerWorkTicksBase;
    }

    @Override
    protected int getUpgradeReducedWork() {
        return ThrEngConfig.processing.energizerWorkTicksUpgrade * this.getUpgradeCount();
    }

    @Override
    protected IPair<ItemStack, Integer> getInput() {
        return IPair.of((Object)this.slotInput.getStackInSlot(), (Object)this.energy.getQuantity());
    }

    @Override
    protected ItemStack getOutputEnvironment() {
        return this.slotOutput.getStackInSlot();
    }

    @Override
    protected void acceptOutput(IPair<ItemStack, Integer> newInputs, ItemStackOutput output) {
        this.slotInput.setStackInSlot((ItemStack)newInputs.getA());
        if (this.slotOutput.getStackInSlot().func_190926_b()) {
            this.slotOutput.setStackInSlot(output.getOutput().func_77946_l());
        } else {
            this.slotOutput.getStackInSlot().func_190917_f(output.getOutput().func_190916_E());
        }
    }

    public IItemHandler getInputSlot() {
        return this.slotInput;
    }

    public IItemHandler getOutputSlot() {
        return this.slotOutput;
    }

    @Override
    protected IItemHandlerModifiable getOutputInventory() {
        return this.slotOutput;
    }

    @Override
    public void collectDrops(Accrue<ItemStack> drops) {
        super.collectDrops(drops);
        InventoryUtils.accrue(drops, (IItemHandler[])new IItemHandler[]{this.slotInput, this.slotOutput});
    }
}

