/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.threng.tile.base;

import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.serialization.AutoSerialize;
import io.github.phantamanta44.libnine.util.data.serialization.IDatum;
import io.github.phantamanta44.threng.tile.base.IActivable;
import io.github.phantamanta44.threng.tile.base.IDirectionable;
import io.github.phantamanta44.threng.tile.base.TileAENetworked;
import net.minecraft.util.EnumFacing;

public abstract class TileNetworkDevice
extends TileAENetworked
implements IDirectionable,
IActivable {
    @AutoSerialize
    private final IDatum<EnumFacing> frontFace = IDatum.of((Object)EnumFacing.NORTH);
    @AutoSerialize
    private final IDatum.OfBool active = IDatum.ofBool((boolean)false);
    private EnumFacing clientFace = EnumFacing.NORTH;
    private boolean clientActive = false;

    @Override
    public boolean isActive() {
        return this.active.isTrue();
    }

    @Override
    public EnumFacing getFrontFace() {
        return (EnumFacing)this.frontFace.get();
    }

    @Override
    public void setFrontFace(EnumFacing face) {
        this.frontFace.set((Object)face);
        this.setDirty();
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange event) {
        this.updateActiveState();
    }

    @MENetworkEventSubscribe
    public void onNetworkChannelsChange(MENetworkChannelsChanged event) {
        this.updateActiveState();
    }

    private void updateActiveState() {
        boolean nowActive = this.getProxy().isActive();
        if (this.active.isTrue() != nowActive) {
            this.active.setBool(nowActive);
            this.setDirty();
        }
    }

    public void deserBytes(ByteUtils.Reader data) {
        boolean isActive;
        super.deserBytes(data);
        boolean needsRenderUpdate = false;
        EnumFacing front = (EnumFacing)this.frontFace.get();
        if (this.clientFace != front) {
            this.clientFace = front;
            needsRenderUpdate = true;
        }
        if (this.clientActive != (isActive = this.active.isTrue())) {
            this.clientActive = isActive;
            needsRenderUpdate = true;
        }
        if (needsRenderUpdate) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }
}

