/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.api.logic;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.api.entities.FactionHome;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPermType;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.format.TextColor;

public interface FactionLogic {
    public Optional<Faction> getFactionByPlayerUUID(UUID var1);

    public Optional<Faction> getFactionByChunk(UUID var1, Vector3i var2);

    @Nullable
    public Faction getFactionByName(String var1);

    public List<Player> getOnlinePlayers(Faction var1);

    public Set<String> getFactionsNames();

    public Map<String, Faction> getFactions();

    public void addFaction(Faction var1);

    public boolean disbandFaction(String var1);

    public void joinFaction(UUID var1, String var2);

    public void leaveFaction(UUID var1, String var2);

    public void addTruce(String var1, String var2);

    public void removeTruce(String var1, String var2);

    public void addAlly(String var1, String var2);

    public void removeAlly(String var1, String var2);

    public void addEnemy(String var1, String var2);

    public void removeEnemy(String var1, String var2);

    public void setLeader(UUID var1, String var2);

    public Map<Claim, Optional<Faction>> getAllClaims();

    public void addClaims(Faction var1, List<Claim> var2);

    public void addClaim(Faction var1, Claim var2);

    public void removeClaim(Faction var1, Claim var2);

    public void destroyClaim(Faction var1, Claim var2);

    public boolean isClaimed(UUID var1, Vector3i var2);

    public boolean isClaimConnected(Faction var1, Claim var2);

    public boolean addClaimOwner(Faction var1, Claim var2, UUID var3);

    public boolean removeClaimOwner(Faction var1, Claim var2, UUID var3);

    public void setClaimAccessibleByFaction(Faction var1, Claim var2, boolean var3);

    public void setHome(Faction var1, @Nullable FactionHome var2);

    public List<String> getFactionsTags();

    public boolean hasOnlinePlayers(Faction var1);

    public void removeAllClaims(Faction var1);

    public void kickPlayer(UUID var1, String var2);

    public void startClaiming(Player var1, Faction var2, UUID var3, Vector3i var4);

    public boolean addClaimByItems(Player var1, Faction var2, UUID var3, Vector3i var4);

    public void togglePerm(Faction var1, FactionMemberType var2, FactionPermType var3, Boolean var4);

    public void changeTagColor(Faction var1, TextColor var2);

    public FactionMemberType promotePlayer(Faction var1, UUID var2);

    public FactionMemberType demotePlayer(Faction var1, UUID var2);

    public void setLastOnline(Faction var1, Instant var2);

    public void renameFaction(Faction var1, String var2);

    public void changeTag(Faction var1, String var2);

    public void setChest(Faction var1, FactionChest var2);

    public void setDescription(Faction var1, String var2);

    public void setMessageOfTheDay(Faction var1, String var2);

    public void setIsPublic(Faction var1, boolean var2);
}

