/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.caching;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class FactionsCache {
    private static final Map<String, Faction> FACTIONS_CACHE = new HashMap<String, Faction>();
    private static final Map<UUID, FactionPlayer> FACTION_PLAYER_CACHE = new HashMap<UUID, FactionPlayer>();
    private static final Cache<Claim, Optional<Faction>> CLAIMS_CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    private FactionsCache() {
    }

    public static Optional<Faction> getClaimFaction(Claim claim) {
        return (Optional)CLAIMS_CACHE.getIfPresent((Object)claim);
    }

    public static void updateClaimFaction(Claim claim, Optional<Faction> faction) {
        CLAIMS_CACHE.put((Object)claim, faction);
    }

    public static Map<UUID, FactionPlayer> getPlayersMap() {
        return FACTION_PLAYER_CACHE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePlayer(FactionPlayer factionPlayer) {
        Map<UUID, FactionPlayer> map = FACTION_PLAYER_CACHE;
        synchronized (map) {
            FACTION_PLAYER_CACHE.put(factionPlayer.getUniqueId(), factionPlayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FactionPlayer getPlayer(UUID playerUniqueId) {
        Map<UUID, FactionPlayer> map = FACTION_PLAYER_CACHE;
        synchronized (map) {
            return FACTION_PLAYER_CACHE.get(playerUniqueId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePlayer(UUID playerUniqueId) {
        Map<UUID, FactionPlayer> map = FACTION_PLAYER_CACHE;
        synchronized (map) {
            FACTION_PLAYER_CACHE.remove(playerUniqueId);
        }
    }

    public static Map<String, Faction> getFactionsMap() {
        return Collections.unmodifiableMap(FACTIONS_CACHE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFaction(Faction faction) {
        Map<String, Faction> map = FACTIONS_CACHE;
        synchronized (map) {
            Faction factionToUpdate = FACTIONS_CACHE.get(faction.getName().toLowerCase());
            if (factionToUpdate != null) {
                FACTIONS_CACHE.replace(factionToUpdate.getName().toLowerCase(), faction);
                factionToUpdate.getClaims().forEach(claim -> CLAIMS_CACHE.put(claim, Optional.empty()));
            } else {
                FACTIONS_CACHE.put(faction.getName().toLowerCase(), faction);
            }
            if (!faction.getClaims().isEmpty()) {
                faction.getClaims().forEach(claim -> CLAIMS_CACHE.put(claim, Optional.of(faction)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFaction(String factionName) {
        Map<String, Faction> map = FACTIONS_CACHE;
        synchronized (map) {
            Faction faction = FACTIONS_CACHE.remove(factionName.toLowerCase());
            faction.getClaims().forEach(claim -> CLAIMS_CACHE.put(claim, Optional.empty()));
        }
    }

    @Nullable
    public static Faction getFaction(String factionName) {
        Faction optionalFaction = FACTIONS_CACHE.get(factionName.toLowerCase());
        return optionalFaction;
    }

    public static Map<Claim, Optional<Faction>> getClaims() {
        return CLAIMS_CACHE.asMap();
    }

    public static void removeClaim(Claim claim) {
        CLAIMS_CACHE.put((Object)claim, Optional.empty());
    }

    public static void clear() {
        CLAIMS_CACHE.invalidateAll();
        FACTIONS_CACHE.clear();
        FACTION_PLAYER_CACHE.clear();
    }
}

