/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.entities;

import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionChest;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.InventoryArchetypes;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.property.InventoryTitle;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class FactionChestImpl
implements FactionChest {
    private String factionName;
    private Inventory inventory;

    public FactionChestImpl(String factionName) {
        this.factionName = factionName;
    }

    public FactionChestImpl(String factionName, List<FactionChest.SlotItem> items) {
        this.factionName = factionName;
        this.inventory = this.buildInventory(items);
    }

    public FactionChestImpl(String factionName, Inventory inventory) {
        this.factionName = factionName;
        this.inventory = this.buildInventory(this.toSlotItems(inventory));
    }

    @Override
    public String getFactionName() {
        return this.factionName;
    }

    @Override
    public List<FactionChest.SlotItem> getItems() {
        if (this.inventory == null) {
            return new ArrayList<FactionChest.SlotItem>();
        }
        return this.toSlotItems(this.inventory);
    }

    @Override
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.buildInventory(new ArrayList<FactionChest.SlotItem>());
        }
        return this.inventory;
    }

    private Inventory buildInventory(List<FactionChest.SlotItem> slotItems) {
        Inventory inventory = Inventory.builder().of(InventoryArchetypes.CHEST).property((InventoryProperty)InventoryTitle.of((Text)Text.of((Object[])new Object[]{TextColors.BLUE, Text.of((String)"Faction's chest")}))).listener(InteractInventoryEvent.Close.class, x -> {
            Faction faction = EagleFactionsPlugin.getPlugin().getFactionLogic().getFactionByName(this.factionName);
            if (faction != null) {
                EagleFactionsPlugin.getPlugin().getFactionLogic().setChest(faction, this);
            }
        }).build((Object)EagleFactionsPlugin.getPlugin());
        int column = 1;
        int row = 1;
        for (Inventory slot : inventory.slots()) {
            ItemStack itemStack = this.getAtPosition(slotItems, row, column);
            if (itemStack != null) {
                slot.offer(itemStack);
            }
            if (++column <= 9) continue;
            column = 1;
            ++row;
        }
        return inventory;
    }

    private List<FactionChest.SlotItem> toSlotItems(Inventory inventory) {
        ArrayList<FactionChest.SlotItem> slotItemList = new ArrayList<FactionChest.SlotItem>();
        Iterable slots = inventory.slots();
        int column = 1;
        int row = 1;
        for (Inventory slot : slots) {
            Optional optionalItemStack = slot.peek();
            if (optionalItemStack.isPresent()) {
                slotItemList.add(new SlotItemImpl(column, row, (ItemStack)optionalItemStack.get()));
            }
            if (++column > 9) {
                ++row;
                column = 1;
            }
            if (row <= 3) continue;
            break;
        }
        return slotItemList;
    }

    private ItemStack getAtPosition(List<FactionChest.SlotItem> items, int row, int column) {
        ItemStack itemStack = null;
        for (FactionChest.SlotItem slotItem : items) {
            if (slotItem.getRow() != row || slotItem.getColumn() != column) continue;
            itemStack = slotItem.getItem().copy();
        }
        return itemStack;
    }

    @ConfigSerializable
    public static final class SlotItemImpl
    implements FactionChest.SlotItem {
        @Setting
        private int column;
        @Setting
        private int row;
        @Setting
        private ItemStack item;

        public SlotItemImpl() {
        }

        public SlotItemImpl(int column, int row, ItemStack item) {
            this.column = column;
            this.row = row;
            this.item = item;
        }

        @Override
        public int getColumn() {
            return this.column;
        }

        @Override
        public int getRow() {
            return this.row;
        }

        @Override
        public ItemStack getItem() {
            return this.item;
        }
    }
}

