/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.events;

import com.flowpowered.math.vector.Vector3i;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionMemberType;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.common.EagleFactionsPlugin;
import io.github.aquerr.eaglefactions.common.events.FactionAreaEnterEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionChestEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionClaimEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionCreateEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionDemoteEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionDisbandEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionInviteEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionJoinEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionKickEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionLeaveEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionPromoteEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionRenameEventImpl;
import io.github.aquerr.eaglefactions.common.events.FactionUnclaimEventImpl;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.event.cause.EventContext;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.world.World;

public final class EventRunner {
    public static boolean runFactionLeaveEventPre(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionLeaveEventImpl.Pre event = new FactionLeaveEventImpl.Pre(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionLeaveEventPost(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionLeaveEventImpl.Post event = new FactionLeaveEventImpl.Post(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionJoinEventPre(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionJoinEventImpl.Pre event = new FactionJoinEventImpl.Pre(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionJoinEventPost(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionJoinEventImpl.Post event = new FactionJoinEventImpl.Post(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionChestEventPre(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionChestEventImpl.Pre event = new FactionChestEventImpl.Pre(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionChestEventPost(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionChestEventImpl.Post event = new FactionChestEventImpl.Post(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionClaimEventPre(Player player, Faction faction, World world, Vector3i chunkPosition) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionClaimEventImpl.Pre event = new FactionClaimEventImpl.Pre(player, faction, world, chunkPosition, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionClaimEventPost(Player player, Faction faction, World world, Vector3i chunkPosition) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionClaimEventImpl.Post event = new FactionClaimEventImpl.Post(player, faction, world, chunkPosition, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionCreateEventPre(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionCreateEventImpl.Pre event = new FactionCreateEventImpl.Pre(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionCreateEventPost(Player player, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionCreateEventImpl.Post event = new FactionCreateEventImpl.Post(player, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionKickEventPre(FactionPlayer kickedPlayer, Player kickedBy, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(kickedBy).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)kickedBy, (Object[])new Object[]{faction});
        FactionKickEventImpl.Pre event = new FactionKickEventImpl.Pre(kickedPlayer, kickedBy, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionKickEventPost(FactionPlayer kickedPlayer, Player kickedBy, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(kickedBy).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)kickedBy, (Object[])new Object[]{faction});
        FactionKickEventImpl.Post event = new FactionKickEventImpl.Post(kickedPlayer, kickedBy, faction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionUnclaimEventPre(Player player, Faction faction, World world, Vector3i chunkPosition) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionUnclaimEventImpl.Pre event = new FactionUnclaimEventImpl.Pre(player, faction, world, chunkPosition, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionUnclaimEventPost(Player player, Faction faction, World world, Vector3i chunkPosition) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionUnclaimEventImpl.Post event = new FactionUnclaimEventImpl.Post(player, faction, world, chunkPosition, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionAreaEnterEventPre(MoveEntityEvent moveEntityEvent, Player player, Optional<Faction> enteredFaction, Optional<Faction> leftFaction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{enteredFaction, leftFaction});
        FactionAreaEnterEventImpl.Pre event = new FactionAreaEnterEventImpl.Pre(moveEntityEvent, player, enteredFaction, leftFaction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionAreaEnterEventPost(MoveEntityEvent moveEntityEvent, Player player, Optional<Faction> enteredFaction, Optional<Faction> leftFaction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause eventCause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{enteredFaction, leftFaction});
        FactionAreaEnterEventImpl.Post event = new FactionAreaEnterEventImpl.Post(moveEntityEvent, player, enteredFaction, leftFaction, eventCause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionRenameEventPre(Player player, Faction faction, String newName) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionRenameEventImpl.Pre event = new FactionRenameEventImpl.Pre(player, faction, newName, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionRenameEventPost(Player player, Faction faction, String newName) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(player).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)player, (Object[])new Object[]{faction});
        FactionRenameEventImpl.Post event = new FactionRenameEventImpl.Post(player, faction, newName, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionDisbandEventPre(Object source, Faction playerFaction, boolean forceRemovedByAdmin, boolean removedDueToInactiviy) {
        EventContext.Builder eventContextBuilder = EventContext.builder();
        Cause.Builder causeBuilder = Cause.builder();
        if (source instanceof Player) {
            Player player = (Player)source;
            eventContextBuilder = EventRunner.getEventContextForPlayer(player);
            causeBuilder.append((Object)player).append((Object)playerFaction);
        } else {
            causeBuilder.append((Object)EagleFactionsPlugin.getPlugin()).append((Object)playerFaction);
        }
        EventContext eventContext = eventContextBuilder.build();
        Cause cause = causeBuilder.build(eventContext);
        FactionDisbandEventImpl.Pre event = source instanceof Player ? new FactionDisbandEventImpl.Pre((Player)source, playerFaction, forceRemovedByAdmin, removedDueToInactiviy, cause) : new FactionDisbandEventImpl.Pre(null, playerFaction, forceRemovedByAdmin, removedDueToInactiviy, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionDisbandEventPost(Object source, Faction playerFaction, boolean forceRemovedByAdmin, boolean removedDueToInactiviy) {
        EventContext.Builder eventContextBuilder = EventContext.builder();
        Cause.Builder causeBuilder = Cause.builder();
        if (source instanceof Player) {
            Player player = (Player)source;
            eventContextBuilder = EventRunner.getEventContextForPlayer(player);
            causeBuilder.append((Object)player).append((Object)playerFaction);
        } else {
            causeBuilder.append((Object)EagleFactionsPlugin.getPlugin()).append((Object)playerFaction);
        }
        EventContext eventContext = eventContextBuilder.build();
        Cause cause = causeBuilder.build(eventContext);
        FactionDisbandEventImpl.Post event = source instanceof Player ? new FactionDisbandEventImpl.Post((Player)source, playerFaction, forceRemovedByAdmin, removedDueToInactiviy, cause) : new FactionDisbandEventImpl.Post(null, playerFaction, forceRemovedByAdmin, removedDueToInactiviy, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionDemoteEventPre(Player demotedBy, FactionPlayer demotedPlayer, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(demotedBy).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)demotedBy, (Object[])new Object[]{faction, demotedPlayer});
        FactionDemoteEventImpl.Pre event = new FactionDemoteEventImpl.Pre(faction, demotedBy, demotedPlayer, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionDemoteEventPost(Player demotedBy, FactionPlayer demotedPlayer, FactionMemberType demotedTo, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(demotedBy).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)demotedBy, (Object[])new Object[]{faction, demotedPlayer});
        FactionDemoteEventImpl.Post event = new FactionDemoteEventImpl.Post(faction, demotedBy, demotedPlayer, demotedTo, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionPromoteEventPre(Player promotedBy, FactionPlayer promotedPlayer, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(promotedBy).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)promotedBy, (Object[])new Object[]{faction, promotedPlayer});
        FactionPromoteEventImpl.Pre event = new FactionPromoteEventImpl.Pre(promotedBy, promotedPlayer, faction, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionPromoteEventPost(Player promotedBy, FactionPlayer promotedPlayer, FactionMemberType promotedToRank, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(promotedBy).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)promotedBy, (Object[])new Object[]{faction, promotedPlayer});
        FactionPromoteEventImpl.Post event = new FactionPromoteEventImpl.Post(promotedBy, promotedPlayer, faction, promotedToRank, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionInviteEventPre(Player inviter, Player invited, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(inviter).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)inviter, (Object[])new Object[]{faction, invited});
        FactionInviteEventImpl.Pre event = new FactionInviteEventImpl.Pre(inviter, invited, faction, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    public static boolean runFactionInviteEventPost(Player inviter, Player invited, Faction faction) {
        EventContext eventContext = EventRunner.getEventContextForPlayer(inviter).build();
        Cause cause = Cause.of((EventContext)eventContext, (Object)inviter, (Object[])new Object[]{faction, invited});
        FactionInviteEventImpl.Post event = new FactionInviteEventImpl.Post(inviter, invited, faction, cause);
        return Sponge.getEventManager().post((Event)event);
    }

    private static EventContext.Builder getEventContextForPlayer(Player player) {
        return EventContext.builder().add(EventContextKeys.OWNER, (Object)player).add(EventContextKeys.PLAYER, (Object)player).add(EventContextKeys.CREATOR, (Object)player);
    }
}

