/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.messaging;

import com.google.inject.Singleton;
import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.serializer.TextSerializers;

@Singleton
public class MessageLoader {
    private final EagleFactions plugin;
    private final FactionsConfig factionsConfig;
    private static MessageLoader instance = null;

    public static MessageLoader getInstance(EagleFactions plugin) {
        if (instance == null) {
            return new MessageLoader(plugin);
        }
        return instance;
    }

    private MessageLoader(EagleFactions plugin) {
        Optional optionalMessagesFile;
        instance = this;
        this.plugin = plugin;
        this.factionsConfig = plugin.getConfiguration().getFactionsConfig();
        Path configDir = plugin.getConfigDir();
        String messagesFileName = this.factionsConfig.getLanguageFileName();
        Path messagesFilePath = configDir.resolve("messages").resolve(messagesFileName);
        if (Files.notExists(configDir.resolve("messages"), new LinkOption[0])) {
            try {
                Files.createDirectory(configDir.resolve("messages"), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if ((optionalMessagesFile = Sponge.getAssetManager().getAsset((Object)plugin, "messages/" + messagesFileName)).isPresent()) {
            try {
                ((Asset)optionalMessagesFile.get()).copyToFile(messagesFilePath, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            optionalMessagesFile = Sponge.getAssetManager().getAsset((Object)plugin, "messages/english.conf");
            optionalMessagesFile.ifPresent(x -> {
                try {
                    x.copyToFile(messagesFilePath, false, true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        HoconConfigurationLoader configLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(messagesFilePath)).build();
        try {
            ConfigurationNode configNode = configLoader.load(ConfigurationOptions.defaults().setShouldCopyDefaults(true));
            this.loadPluginMessages(configNode, (ConfigurationLoader<CommentedConfigurationNode>)configLoader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadPluginMessages(ConfigurationNode configNode, ConfigurationLoader<CommentedConfigurationNode> configLoader) {
        Field[] messageFields = Messages.class.getFields();
        boolean missingNodes = false;
        for (Field messageField : messageFields) {
            String message = configNode.getNode(new Object[]{messageField.getName()}).getString();
            if (message == null || message.equals("")) {
                missingNodes = true;
                try {
                    configNode.getNode(new Object[]{messageField.getName()}).setValue(messageField.get(null));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                messageField.set(Messages.class.getClass(), message);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (missingNodes) {
            try {
                configLoader.save(configNode);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Text parseMessage(String message, TextColor messageBaseColor, Map<Placeholder, Text> placeholdersMap) {
        String[] splitMessage;
        Text.Builder resultText = Text.builder();
        for (String word : splitMessage = message.split(" ")) {
            boolean didFill = false;
            for (Map.Entry<Placeholder, Text> mapEntry : placeholdersMap.entrySet()) {
                if (!word.contains(mapEntry.getKey().getPlaceholder())) continue;
                String placeholderReplacement = TextSerializers.FORMATTING_CODE.serialize(mapEntry.getValue().toBuilder().append(new Text[]{Text.of((Object[])new Object[]{messageBaseColor})}).build());
                String filledPlaceholder = word.replace(mapEntry.getKey().getPlaceholder(), placeholderReplacement);
                Text formattedText = TextSerializers.FORMATTING_CODE.deserialize(filledPlaceholder + " ");
                resultText.append(new Text[]{formattedText});
                didFill = true;
                break;
            }
            if (didFill) continue;
            resultText.append(new Text[]{Text.of((Object[])new Object[]{messageBaseColor, word + " "})});
        }
        return resultText.build();
    }
}

