/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.scheduling;

import com.flowpowered.math.vector.Vector3i;
import com.google.common.collect.ImmutableMap;
import io.github.aquerr.eaglefactions.api.config.FactionsConfig;
import io.github.aquerr.eaglefactions.api.entities.Claim;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.logic.AttackLogic;
import io.github.aquerr.eaglefactions.api.logic.FactionLogic;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.messaging.MessageLoader;
import io.github.aquerr.eaglefactions.common.messaging.Messages;
import io.github.aquerr.eaglefactions.common.messaging.Placeholder;
import io.github.aquerr.eaglefactions.common.messaging.Placeholders;
import io.github.aquerr.eaglefactions.common.scheduling.EagleFactionsConsumerTask;
import java.util.Map;
import java.util.Optional;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.chat.ChatTypes;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class AttackClaimTask
implements EagleFactionsConsumerTask<Task> {
    int seconds = 1;
    private final FactionsConfig factionsConfig;
    private final FactionLogic factionLogic;
    private final AttackLogic attackLogic;
    private final Vector3i attackedChunk;
    private final Player player;

    public AttackClaimTask(FactionsConfig factionsConfig, FactionLogic factionLogic, AttackLogic attackLogic, Player player, Vector3i attackedChunk) {
        this.factionsConfig = factionsConfig;
        this.factionLogic = factionLogic;
        this.attackLogic = attackLogic;
        this.player = player;
        this.attackedChunk = attackedChunk;
    }

    @Override
    public void accept(Task task) {
        if ((Double)this.player.health().get() <= 0.0) {
            this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.ATTACK_ON_CLAIM_HAS_BEEN_CANCELLED}));
            task.cancel();
        }
        if (!this.attackedChunk.equals((Object)this.player.getLocation().getChunkPosition())) {
            this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.ERROR_PREFIX, TextColors.RED, Messages.YOU_MOVED_FROM_THE_CHUNK}));
            task.cancel();
        }
        if (this.seconds >= this.factionsConfig.getAttackTime()) {
            Optional<Faction> optionalChunkFaction = this.factionLogic.getFactionByChunk(this.player.getWorld().getUniqueId(), this.attackedChunk);
            if (!optionalChunkFaction.isPresent()) {
                task.cancel();
                return;
            }
            Faction chunkFaction = optionalChunkFaction.get();
            this.attackLogic.informAboutDestroying(chunkFaction, (Location<World>)this.player.getLocation());
            this.player.sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.GREEN, Messages.CLAIM_DESTROYED}));
            Claim claim = new Claim(this.player.getWorld().getUniqueId(), this.attackedChunk);
            this.factionLogic.destroyClaim(chunkFaction, claim);
            task.cancel();
        } else {
            this.player.sendMessage(ChatTypes.ACTION_BAR, MessageLoader.parseMessage(Messages.CLAIM_WILL_BE_DESTROYED_IN_SECONDS, TextColors.AQUA, (Map<Placeholder, Text>)ImmutableMap.of((Object)Placeholders.NUMBER, (Object)Text.of((Object[])new Object[]{TextColors.GOLD, this.seconds}))));
            ++this.seconds;
        }
    }
}

