/*
 * Decompiled with CFR 0.152.
 */
package io.github.aquerr.eaglefactions.common.storage;

import io.github.aquerr.eaglefactions.api.EagleFactions;
import io.github.aquerr.eaglefactions.api.config.StorageConfig;
import io.github.aquerr.eaglefactions.api.entities.Faction;
import io.github.aquerr.eaglefactions.api.entities.FactionPlayer;
import io.github.aquerr.eaglefactions.api.storage.StorageManager;
import io.github.aquerr.eaglefactions.common.PluginInfo;
import io.github.aquerr.eaglefactions.common.caching.FactionsCache;
import io.github.aquerr.eaglefactions.common.entities.FactionPlayerImpl;
import io.github.aquerr.eaglefactions.common.storage.BackupStorage;
import io.github.aquerr.eaglefactions.common.storage.FactionStorage;
import io.github.aquerr.eaglefactions.common.storage.PlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.HOCONFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.file.hocon.HOCONPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.h2.H2FactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.h2.H2PlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mariadb.MariaDbFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mariadb.MariaDbPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mysql.MySQLFactionStorage;
import io.github.aquerr.eaglefactions.common.storage.sql.mysql.MySQLPlayerStorage;
import io.github.aquerr.eaglefactions.common.storage.task.DeleteFactionTask;
import io.github.aquerr.eaglefactions.common.storage.task.IStorageTask;
import io.github.aquerr.eaglefactions.common.storage.task.SavePlayerTask;
import io.github.aquerr.eaglefactions.common.storage.task.UpdateFactionTask;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

public class StorageManagerImpl
implements StorageManager {
    private final FactionStorage factionsStorage;
    private final PlayerStorage playerStorage;
    private final BackupStorage backupStorage;
    private final Path configDir;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public StorageManagerImpl(EagleFactions plugin, StorageConfig storageConfig, Path configDir) {
        this.configDir = configDir;
        switch (storageConfig.getStorageType().toLowerCase()) {
            case "hocon": {
                this.factionsStorage = new HOCONFactionStorage(configDir);
                this.playerStorage = new HOCONPlayerStorage(configDir);
                plugin.printInfo("HOCON storage has been initialized!");
                break;
            }
            case "h2": {
                this.factionsStorage = new H2FactionStorage(plugin);
                this.playerStorage = new H2PlayerStorage(plugin);
                plugin.printInfo("H2 storage has been initialized!");
                break;
            }
            case "mysql": {
                this.factionsStorage = new MySQLFactionStorage(plugin);
                this.playerStorage = new MySQLPlayerStorage(plugin);
                plugin.printInfo("MySQL storage has been initialized!");
                break;
            }
            case "mariadb": {
                this.factionsStorage = new MariaDbFactionStorage(plugin);
                this.playerStorage = new MariaDbPlayerStorage(plugin);
                plugin.printInfo("MariaDB storage has been initialized!");
                break;
            }
            default: {
                plugin.printInfo("Couldn't find provided storage type.");
                this.factionsStorage = new HOCONFactionStorage(configDir);
                this.playerStorage = new HOCONPlayerStorage(configDir);
                plugin.printInfo("Initialized default HOCON storage.");
            }
        }
        this.backupStorage = new BackupStorage(this.factionsStorage, this.playerStorage, configDir);
        Sponge.getServer().getConsole().sendMessage(Text.of((Object[])new Object[]{PluginInfo.PLUGIN_PREFIX, TextColors.AQUA, "Filling cache with data..."}));
        this.prepareFactionsCache();
        this.preparePlayerCache();
    }

    private void queueStorageTask(IStorageTask task) {
        this.executorService.submit(task);
    }

    @Override
    public void saveFaction(Faction faction) {
        this.queueStorageTask(new UpdateFactionTask(faction, () -> this.factionsStorage.saveFaction(faction)));
        FactionsCache.saveFaction(faction);
    }

    @Override
    public boolean deleteFaction(String factionName) {
        this.queueStorageTask(new DeleteFactionTask(factionName, () -> this.factionsStorage.deleteFaction(factionName)));
        FactionsCache.removeFaction(factionName);
        return true;
    }

    @Override
    @Nullable
    public Faction getFaction(String factionName) {
        try {
            Faction factionCache = FactionsCache.getFaction(factionName);
            if (factionCache != null) {
                return factionCache;
            }
            Faction faction = this.factionsStorage.getFaction(factionName);
            if (faction == null) {
                return null;
            }
            FactionsCache.saveFaction(faction);
            return faction;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void prepareFactionsCache() {
        Set<Faction> factionSet = this.factionsStorage.getFactions();
        for (Faction faction : factionSet) {
            FactionsCache.saveFaction(faction);
        }
    }

    private void preparePlayerCache() {
        Set<FactionPlayer> players = this.playerStorage.getServerPlayers();
        Collection<Faction> factions = FactionsCache.getFactionsMap().values();
        Iterator iterator = players.iterator();
        while (iterator.hasNext()) {
            FactionPlayer player;
            FactionPlayer playerToSave = player = (FactionPlayer)iterator.next();
            if (!player.getFactionName().isPresent()) {
                for (Faction faction : factions) {
                    if (!faction.containsPlayer(player.getUniqueId())) continue;
                    playerToSave = new FactionPlayerImpl(player.getName(), player.getUniqueId(), faction.getName(), player.getPower(), player.getMaxPower(), player.getFactionRole(), player.diedInWarZone());
                }
            }
            FactionsCache.savePlayer(playerToSave);
        }
    }

    @Override
    public void reloadStorage() {
        FactionsCache.clear();
        this.factionsStorage.load();
        this.prepareFactionsCache();
        this.preparePlayerCache();
    }

    @Override
    public boolean savePlayer(FactionPlayer factionPlayer) {
        this.queueStorageTask(new SavePlayerTask(factionPlayer, () -> this.playerStorage.savePlayer(factionPlayer)));
        FactionsCache.savePlayer(factionPlayer);
        return true;
    }

    @Override
    @Nullable
    public FactionPlayer getPlayer(UUID playerUUID) {
        try {
            FactionPlayer cachedPlayer = FactionsCache.getPlayer(playerUUID);
            if (cachedPlayer != null) {
                return cachedPlayer;
            }
            FactionPlayer player = this.playerStorage.getPlayer(playerUUID);
            if (player == null) {
                return null;
            }
            FactionsCache.savePlayer(player);
            return player;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<String> getServerPlayerNames() {
        return this.playerStorage.getServerPlayerNames();
    }

    @Override
    public Set<FactionPlayer> getServerPlayers() {
        return this.playerStorage.getServerPlayers();
    }

    @Override
    public boolean createBackup() {
        return this.backupStorage.createBackup();
    }

    @Override
    public boolean restoreBackup(String backupName) {
        try {
            return this.backupStorage.restoreBackup(backupName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<String> listBackups() {
        return this.backupStorage.listBackups();
    }
}

