/*
 * Decompiled with CFR 0.152.
 */
package com.erigitic.shops;

import java.util.Optional;
import java.util.UUID;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.InvalidDataException;

public class Shop
implements DataSerializable {
    public static final DataQuery OWNER_QUERY = DataQuery.of((String[])new String[]{"Owner"});
    public static final DataQuery TITLE_QUERY = DataQuery.of((String[])new String[]{"Title"});
    private UUID owner;
    private String title;

    public Shop(UUID owner, String title) {
        this.owner = owner;
        this.title = title;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getContentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew().set(OWNER_QUERY, (Object)this.getOwner()).set(TITLE_QUERY, (Object)this.getTitle()).set(Queries.CONTENT_VERSION, (Object)1);
    }

    public static class Builder
    extends AbstractDataBuilder<Shop> {
        public Builder() {
            super(Shop.class, 1);
        }

        public Optional<Shop> buildContent(DataView container) throws InvalidDataException {
            if (container.contains(OWNER_QUERY, new DataQuery[]{TITLE_QUERY})) {
                UUID owner = (UUID)container.getObject(OWNER_QUERY, UUID.class).get();
                String title = (String)container.getString(TITLE_QUERY).get();
                return Optional.of(new Shop(owner, title));
            }
            return Optional.empty();
        }
    }
}

