/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.property.IUnlistedProperty;

public class PropertyTableItem
implements IUnlistedProperty<TableItems> {
    public String getName() {
        return "TableItems";
    }

    public boolean isValid(TableItems value) {
        return value != null && value.items != null;
    }

    public Class<TableItems> getType() {
        return TableItems.class;
    }

    public String valueToString(TableItems value) {
        return value.toString();
    }

    public static class TableItem {
        public final ItemStack stack;
        public final IBakedModel model;
        public float x;
        public float y;
        public float z;
        public float s;
        public float r;

        public TableItem(ItemStack stack, IBakedModel model) {
            this(stack, model, 0.0f, 0.0f, 0.0f);
        }

        public TableItem(ItemStack stack, IBakedModel model, float x, float y, float z) {
            this(stack, model, x, y, z, 1.0f, 0.0f);
        }

        public TableItem(ItemStack stack, IBakedModel model, float x, float y, float z, float s, float r) {
            this.stack = stack;
            this.model = model;
            this.x = x;
            this.y = y;
            this.z = z;
            this.s = s;
            this.r = r;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableItem tableItem = (TableItem)o;
            if (Float.compare(tableItem.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(tableItem.y, this.y) != 0) {
                return false;
            }
            if (Float.compare(tableItem.z, this.z) != 0) {
                return false;
            }
            if (Float.compare(tableItem.s, this.s) != 0) {
                return false;
            }
            if (Float.compare(tableItem.r, this.r) != 0) {
                return false;
            }
            return this.stack != null ? ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)tableItem.stack) : tableItem.stack == null;
        }

        public int hashCode() {
            int result = 0;
            if (this.stack != null) {
                result = this.stack.func_77973_b().hashCode();
                result = 31 * result + this.stack.func_190916_E();
                result = 31 * result + (this.stack.func_77978_p() != null ? this.stack.func_77978_p().hashCode() : 0);
            }
            result = 31 * result + (this.x != 0.0f ? Float.floatToIntBits(this.x) : 0);
            result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
            result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
            result = 31 * result + (this.s != 0.0f ? Float.floatToIntBits(this.s) : 0);
            result = 31 * result + (this.r != 0.0f ? Float.floatToIntBits(this.r) : 0);
            return result;
        }
    }

    public static class TableItems {
        public static final TableItems EMPTY = new TableItems();
        public List<TableItem> items = Lists.newLinkedList();

        static {
            TableItems.EMPTY.items = ImmutableList.of();
        }
    }
}

