/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.tileentity;

import gcewing.sg.BaseTileEntity;
import gcewing.sg.tileentity.SGBaseTE;
import gcewing.sg.util.SGAddressing;
import gcewing.sg.util.SGState;
import net.minecraft.world.IBlockAccess;

public class SGInterfaceTE
extends BaseTileEntity {
    public SGBaseTE getBaseTE() {
        return SGBaseTE.get((IBlockAccess)this.func_145831_w(), this.field_174879_c.func_177982_a(0, 1, 0));
    }

    public static Object[] prependArgs(Object ... args) {
        int preLength = args.length - 1;
        Object[] post = (Object[])args[preLength];
        Object[] xargs = new Object[preLength + post.length];
        System.arraycopy(args, 0, xargs, 0, preLength);
        System.arraycopy(post, 0, xargs, preLength, post.length);
        return xargs;
    }

    public void rebroadcastNetworkPacket(Object packet) {
    }

    public SGBaseTE requireBaseTE() {
        SGBaseTE te = this.getBaseTE();
        if (te != null && te.isMerged) {
            return te;
        }
        throw new IllegalArgumentException("missingStargate");
    }

    public SGBaseTE requireIrisTE() {
        SGBaseTE te = this.requireBaseTE();
        if (te != null && te.hasIrisUpgrade) {
            return te;
        }
        throw new IllegalArgumentException("missingIris");
    }

    String directionDescription(SGBaseTE te) {
        if (te.state != SGState.Idle) {
            if (te.isInitiator) {
                return "Outgoing";
            }
            return "Incoming";
        }
        return "Not Connected";
    }

    public CIStargateState ciStargateState() {
        SGBaseTE te = this.getBaseTE();
        if (te != null) {
            return new CIStargateState(te.sgStateDescription(), te.numEngagedChevrons, this.directionDescription(te));
        }
        return new CIStargateState("Offline", 0, "");
    }

    public double ciEnergyAvailable() {
        SGBaseTE te = this.getBaseTE();
        return te != null ? te.availableEnergy() : 0.0;
    }

    public double ciEnergyToDial(String address, boolean pending) {
        SGBaseTE te = this.requireBaseTE();
        try {
            address = SGAddressing.normalizeAddress(address);
            SGBaseTE dte = SGAddressing.findAddressedStargate(address, te.func_145831_w(), pending);
            if (dte == null) {
                throw new IllegalArgumentException("unknownAddress");
            }
            double distanceFactor = dte.distanceFactorForCoordDifference(te, dte);
            return SGBaseTE.energyToOpen * distanceFactor;
        }
        catch (SGAddressing.AddressingError e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String ciLocalAddress() {
        SGBaseTE te = this.getBaseTE();
        try {
            return te != null ? te.getHomeAddress() : "";
        }
        catch (SGAddressing.AddressingError e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String ciRemoteAddress() {
        SGBaseTE te = this.requireBaseTE();
        try {
            return te.connectedLocation != null ? SGAddressing.addressForLocation(te.connectedLocation) : "";
        }
        catch (SGAddressing.AddressingError e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void ciDial(String address, boolean pending) {
        SGBaseTE te = this.requireBaseTE();
        String error = te.connect(address = SGAddressing.normalizeAddress(address), null, true, pending);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public void ciDisconnect() {
        SGBaseTE te = this.requireBaseTE();
        String error = te.disconnect(null);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public String ciIrisState() {
        SGBaseTE te = this.getBaseTE();
        return te != null && te.hasIrisUpgrade ? te.irisStateDescription() : "Offline";
    }

    public void ciOpenIris() {
        this.requireIrisTE().openIris();
    }

    public void ciCloseIris() {
        this.requireIrisTE().closeIris();
    }

    public void ciSendMessage(Object[] args) {
        SGBaseTE te = this.requireBaseTE();
        String error = te.sendMessage(args);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
    }

    public static class CIStargateState {
        public String state;
        public int chevrons;
        public String direction;

        public CIStargateState(String state, int chevrons, String direction) {
            this.state = state;
            this.chevrons = chevrons;
            this.direction = direction;
        }
    }
}

