/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.inventory;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.ndrei.teslacorelib.inventory.IFilteredItemHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0014\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lnet/ndrei/teslacorelib/inventory/FilteredItemHandler;", "Lnet/ndrei/teslacorelib/inventory/IFilteredItemHandler;", "innerHandler", "Lnet/minecraftforge/items/IItemHandler;", "(Lnet/minecraftforge/items/IItemHandler;)V", "getInnerHandler", "()Lnet/minecraftforge/items/IItemHandler;", "canExtractItem", "", "slot", "", "canInsertItem", "stack", "Lnet/minecraft/item/ItemStack;", "extractItem", "amount", "simulate", "getSlotLimit", "getSlots", "getStackInSlot", "insertItem", "setStackInSlot", "", "tesla-core-lib"})
public class FilteredItemHandler
implements IFilteredItemHandler {
    @NotNull
    private final IItemHandler innerHandler;

    @Override
    public boolean canInsertItem(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return this.innerHandler instanceof IFilteredItemHandler ? ((IFilteredItemHandler)this.innerHandler).canInsertItem(slot, stack) : true;
    }

    @Override
    public boolean canExtractItem(int slot) {
        return this.innerHandler instanceof IFilteredItemHandler ? ((IFilteredItemHandler)this.innerHandler).canExtractItem(slot) : true;
    }

    public int getSlots() {
        return this.innerHandler.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.innerHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        ItemStack itemStack = this.innerHandler.insertItem(slot, stack, simulate);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.innerHandler.insert\u2026em(slot, stack, simulate)");
        return itemStack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.canExtractItem(slot)) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
            return itemStack;
        }
        ItemStack itemStack = this.innerHandler.extractItem(slot, amount, simulate);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"this.innerHandler.extrac\u2026m(slot, amount, simulate)");
        return itemStack;
    }

    public int getSlotLimit(int slot) {
        return this.innerHandler.getSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        if (!(this.innerHandler instanceof IItemHandlerModifiable)) {
            throw (Throwable)new RuntimeException("Inner item handler is not modifiable.");
        }
        ((IItemHandlerModifiable)this.innerHandler).setStackInSlot(slot, stack);
    }

    @NotNull
    public final IItemHandler getInnerHandler() {
        return this.innerHandler;
    }

    protected FilteredItemHandler(@NotNull IItemHandler innerHandler) {
        Intrinsics.checkParameterIsNotNull((Object)innerHandler, (String)"innerHandler");
        this.innerHandler = innerHandler;
    }
}

