/*
 * Decompiled with CFR 0.152.
 */
package guichaguri.betterfps.patchers;

import guichaguri.betterfps.transformers.ASMUtils;
import guichaguri.betterfps.transformers.IClassPatcher;
import guichaguri.betterfps.transformers.Patch;
import guichaguri.betterfps.tweaker.Mappings;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class FastHopperPatcher
implements IClassPatcher {
    public static final String PICKUP_ITEMS = "pickupItems";

    @Override
    public void patch(Patch patch) {
        ClassNode source = patch.getSourceClass();
        ClassNode target = patch.getTargetClass();
        MethodNode method = ASMUtils.findMethod(target, Mappings.M_captureDroppedItems);
        if (method == null) {
            return;
        }
        MethodNode pickupItem = patch.getMethod(PICKUP_ITEMS);
        InsnList inst = method.instructions;
        List<JumpInsnNode> ifNullNodes = ASMUtils.findNodes(inst, JumpInsnNode.class, 198);
        LocalVariableNode inv = ASMUtils.findVariable(method, Mappings.C_IInventory);
        if (ifNullNodes == null || ifNullNodes.isEmpty() || inv == null) {
            return;
        }
        JumpInsnNode ifNull = null;
        JumpInsnNode ifEnd = null;
        for (JumpInsnNode node : ifNullNodes) {
            AbstractInsnNode previous = node.getPrevious();
            if (!(previous instanceof VarInsnNode) || ((VarInsnNode)previous).var != inv.index) continue;
            ifNull = node;
            break;
        }
        if (ifNull == null) {
            return;
        }
        for (int i = inst.indexOf((AbstractInsnNode)ifNull.label) - 1; i >= 0; --i) {
            JumpInsnNode node;
            node = inst.get(i);
            if (!(node instanceof JumpInsnNode) || node.getOpcode() != 167) continue;
            ifEnd = node;
            break;
        }
        if (ifEnd == null) {
            return;
        }
        InsnList ifCanPickupItems = ASMUtils.insertMethod(source, pickupItem, target, method, (AbstractInsnNode)ifNull.label, false);
        ifCanPickupItems.add((AbstractInsnNode)new JumpInsnNode(153, ifEnd.label));
        inst.insert((AbstractInsnNode)ifNull.label, ifCanPickupItems);
    }
}

