/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.advancement;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.DisplayInfo;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.advancement.SpongeCriterionHelper;
import org.spongepowered.common.bridge.advancements.AdvancementBridge;
import org.spongepowered.common.registry.type.advancement.AdvancementRegistryModule;
import org.spongepowered.common.util.SpongeCatalogBuilder;

public class SpongeAdvancementBuilder
extends SpongeCatalogBuilder<Advancement, Advancement.Builder>
implements Advancement.Builder {
    @Nullable
    private Advancement parent;
    private AdvancementCriterion criterion;
    @Nullable
    private DisplayInfo displayInfo;

    public SpongeAdvancementBuilder() {
        this.reset();
    }

    @Override
    public Advancement.Builder parent(@Nullable Advancement parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public Advancement.Builder criterion(AdvancementCriterion criterion) {
        Preconditions.checkNotNull((Object)criterion, (Object)"criterion");
        this.criterion = criterion;
        return this;
    }

    @Override
    public Advancement.Builder displayInfo(@Nullable DisplayInfo displayInfo) {
        this.displayInfo = displayInfo;
        return this;
    }

    @Override
    protected Advancement build(PluginContainer plugin, String id, Translation name) {
        Tuple<Map<String, Criterion>, String[][]> result = SpongeCriterionHelper.toVanillaCriteriaData(this.criterion);
        AdvancementRewards rewards = AdvancementRewards.field_192114_a;
        ResourceLocation resourceLocation = new ResourceLocation(plugin.getId(), this.id);
        net.minecraft.advancements.DisplayInfo displayInfo = this.displayInfo == null ? null : (net.minecraft.advancements.DisplayInfo)((DisplayInfo.Builder)DisplayInfo.builder().from(this.displayInfo)).build();
        net.minecraft.advancements.Advancement parent = (net.minecraft.advancements.Advancement)this.parent;
        if (parent == null) {
            parent = AdvancementRegistryModule.DUMMY_ROOT_ADVANCEMENT;
        }
        Advancement advancement = (Advancement)new net.minecraft.advancements.Advancement(resourceLocation, parent, displayInfo, rewards, result.getFirst(), result.getSecond());
        ((AdvancementBridge)((Object)advancement)).bridge$setCriterion(this.criterion);
        String plainName = name.get();
        if (StringUtils.isNotEmpty((CharSequence)plainName)) {
            ((AdvancementBridge)((Object)advancement)).bridge$setName(plainName);
        }
        return advancement;
    }

    @Override
    public Advancement.Builder reset() {
        this.criterion = AdvancementCriterion.EMPTY;
        this.displayInfo = null;
        this.parent = null;
        this.id = null;
        this.name = null;
        return this;
    }
}

