/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.config;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationVisitor;
import ninja.leaping.configurate.Types;

class DuplicateRemovalVisitor
implements ConfigurationVisitor.Safe<AtomicReference<ConfigurationNode>, Void> {
    private static final DuplicateRemovalVisitor INSTANCE = new DuplicateRemovalVisitor();

    private DuplicateRemovalVisitor() {
    }

    public static void visit(ConfigurationNode child, ConfigurationNode parent) {
        child.visit(INSTANCE, new AtomicReference<ConfigurationNode>(parent));
    }

    @Override
    public AtomicReference<ConfigurationNode> newState() {
        throw new IllegalArgumentException("A parent configuration must be provided as the state object to properly remove duplicates");
    }

    private boolean isListElement(ConfigurationNode node) {
        return node.getParent() != null && node.getParent().isList();
    }

    @Override
    public void beginVisit(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        Preconditions.checkNotNull(((AtomicReference)Preconditions.checkNotNull(parent, (Object)"parentRef")).get(), (Object)"A parent configuration must be provided!");
    }

    @Override
    public void enterNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        if (node.getParent() != null) {
            parent.set(parent.get().getNode(node.getKey()));
        }
    }

    @Override
    public void enterMappingNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
    }

    @Override
    public void enterListNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        if (!this.isListElement(node) && Objects.equals(node.getValue(), parent.get().getValue())) {
            node.setValue(null);
        }
    }

    @Override
    public void enterScalarNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        Double parentVal;
        ConfigurationNode parentNode = this.popParent(parent);
        if (this.isListElement(node)) {
            return;
        }
        if (Objects.equals(node.getValue(), parentNode.getValue())) {
            node.setValue(null);
            return;
        }
        Double nodeVal = node.getValue(Types::asDouble);
        if (nodeVal != null && ((parentVal = parentNode.getValue(Types::asDouble)) == null && nodeVal == 0.0 || parentVal != null && nodeVal.doubleValue() == parentVal.doubleValue())) {
            node.setValue(null);
        }
    }

    @Override
    public void exitMappingNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        this.popParent(parent);
        if (node.isEmpty() && !this.isListElement(node)) {
            node.setValue(null);
        }
    }

    @Override
    public void exitListNode(ConfigurationNode node, AtomicReference<ConfigurationNode> parent) {
        ConfigurationNode parentNode = this.popParent(parent);
        if (parentNode.isEmpty() && node.isEmpty()) {
            node.setValue(null);
        }
    }

    @Override
    public Void endVisit(AtomicReference<ConfigurationNode> parent) {
        return null;
    }

    private ConfigurationNode popParent(AtomicReference<ConfigurationNode> parentRef) {
        ConfigurationNode parent = parentRef.get();
        if (parent.getParent() != null) {
            parentRef.set(parent.getParent());
        }
        return parent;
    }
}

