/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.ConfigurationVisitor;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.persistence.DataTranslator;
import org.spongepowered.api.data.persistence.InvalidDataException;

public class ConfigurateTranslator
implements DataTranslator<ConfigurationNode> {
    private static final ConfigurateTranslator INSTANCE = new ConfigurateTranslator();
    private static final TypeToken<ConfigurationNode> TOKEN = TypeToken.of(ConfigurationNode.class);
    private static final ConfigurationOptions DEFAULT_OPTS = ConfigurationOptions.defaults().withNativeTypes((Set<Class<?>>)ImmutableSet.of(Map.class, List.class, Double.class, Long.class, Integer.class, Boolean.class, (Object[])new Class[]{String.class}));

    public static ConfigurateTranslator instance() {
        return INSTANCE;
    }

    private ConfigurateTranslator() {
    }

    @Override
    public String getId() {
        return "sponge:configuration_node";
    }

    @Override
    public String getName() {
        return "ConfigurationNodeTranslator";
    }

    @Override
    public TypeToken<ConfigurationNode> getToken() {
        return TOKEN;
    }

    public void translateDataToNode(ConfigurationNode node, DataView view) {
        Preconditions.checkNotNull((Object)node, (Object)"node");
        Preconditions.checkNotNull((Object)view, (Object)"container");
        Map<Object, ? extends ConfigurationNode> originalMap = node.getChildrenMap();
        if (originalMap.isEmpty()) {
            node.setValue(ImmutableMap.of());
        }
        HashSet<Object> unvisitedKeys = new HashSet<Object>(originalMap.keySet());
        for (DataQuery dataQuery : view.getKeys(false)) {
            this.valueToNode(node.getNode(dataQuery.getParts()), view.get(dataQuery).orElse(null));
            unvisitedKeys.remove(dataQuery.getParts().get(0));
        }
        for (DataQuery dataQuery : unvisitedKeys) {
            node.removeChild(dataQuery);
        }
    }

    private void valueToNode(ConfigurationNode node, @Nullable Object value) {
        if (value instanceof DataView) {
            this.translateDataToNode(node, (DataView)value);
        } else if (value instanceof Collection) {
            node.setValue(ImmutableList.of());
            for (Object child : (Collection)value) {
                this.valueToNode(node.appendListNode(), child);
            }
        } else if (value == null) {
            node.setValue(null);
        } else {
            Class<?> vClazz = value.getClass();
            if (node.getOptions().acceptsType(vClazz)) {
                node.setValue(value);
            } else {
                TypeToken token = TypeToken.of(vClazz);
                @Nullable TypeSerializer<Object> serial = node.getOptions().getSerializers().get(token);
                if (serial != null) {
                    try {
                        serial.serialize(token, value, node);
                    }
                    catch (ObjectMappingException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else {
                    throw new IllegalArgumentException("DataView value type of " + token + " is not supported by the provided ConfigurationNode");
                }
            }
        }
    }

    @Override
    public ConfigurationNode translate(DataView view) throws InvalidDataException {
        ConfigurationNode node = ConfigurationNode.root(DEFAULT_OPTS);
        this.translateDataToNode(node, view);
        return node;
    }

    @Override
    public DataContainer translate(ConfigurationNode obj) throws InvalidDataException {
        DataView view = obj.visit(ToDataView.INSTANCE);
        if (!(view instanceof DataContainer)) {
            throw new IllegalStateException("Returned data view was not the original container!");
        }
        return (DataContainer)view;
    }

    @Override
    public DataView addTo(ConfigurationNode node, DataView dataView) {
        VisitState state = new VisitState();
        state.add(dataView);
        node.visit(ToDataView.INSTANCE, state);
        return dataView;
    }

    static class ToDataView
    implements ConfigurationVisitor.Safe<VisitState, DataView> {
        static ToDataView INSTANCE = new ToDataView();

        private ToDataView() {
        }

        private DataQuery queryFrom(ConfigurationNode node) {
            Object key = node.getKey();
            if (key == null) {
                throw new IllegalArgumentException("Null keys are not supported in data views (at " + Arrays.toString(node.getPath()) + ")");
            }
            return DataQuery.of(key.toString());
        }

        @Override
        public VisitState newState() {
            VisitState ret = new VisitState();
            ret.add(DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED));
            return ret;
        }

        @Override
        public void beginVisit(ConfigurationNode node, VisitState state) {
            if (!node.isEmpty() && !node.isMap()) {
                throw new IllegalArgumentException("Only mapping nodes can be represented in DataViews");
            }
            state.start = node;
        }

        @Override
        public void enterNode(ConfigurationNode node, VisitState state) {
        }

        @Override
        public void enterMappingNode(ConfigurationNode node, VisitState state) {
            DataView ret;
            if (state.start == node) {
                state.addFirst(state.getFirst());
                return;
            }
            Object peek = state.getFirst();
            if (peek instanceof DataView) {
                ret = ((DataView)peek).createView(this.queryFrom(node));
            } else if (peek instanceof List) {
                ret = DataContainer.createNew(DataView.SafetyMode.NO_DATA_CLONED);
                ((List)peek).add(ret);
            } else {
                throw new Error("Unknown peek type of " + peek.getClass());
            }
            state.addFirst(ret);
        }

        @Override
        public void enterListNode(ConfigurationNode node, VisitState state) {
            state.addFirst(new LinkedList());
        }

        @Override
        public void enterScalarNode(ConfigurationNode node, VisitState state) {
            this.addToFirst(state, node, node.getValue());
        }

        @Override
        public void exitMappingNode(ConfigurationNode node, VisitState state) {
            if (!(state.removeFirst() instanceof DataView)) {
                throw new IllegalStateException("Exited a mapping node but the top value was not a DataView");
            }
        }

        @Override
        public void exitListNode(ConfigurationNode node, VisitState state) {
            Object popped = state.removeFirst();
            this.addToFirst(state, node, popped);
        }

        private void addToFirst(Deque<Object> stack, ConfigurationNode keySource, Object value) {
            Object peek = stack.getFirst();
            if (peek instanceof DataView) {
                ((DataView)peek).set(this.queryFrom(keySource), value);
            } else if (peek instanceof List) {
                ((List)peek).add(value);
            }
        }

        @Override
        public DataView endVisit(VisitState state) {
            state.start = null;
            return (DataView)state.remove();
        }
    }

    static class VisitState
    extends LinkedList<Object> {
        @Nullable ConfigurationNode start;

        VisitState() {
        }
    }
}

