/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.item.EntityItemFrame;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.ImmutableRotationalData;
import org.spongepowered.api.data.manipulator.mutable.RotationalData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.util.rotation.Rotation;
import org.spongepowered.api.util.rotation.Rotations;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.SpongeRotationalData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;

public class RotationalDataProcessor
extends AbstractEntitySingleDataProcessor<EntityItemFrame, Rotation, Value<Rotation>, RotationalData, ImmutableRotationalData> {
    public RotationalDataProcessor() {
        super(EntityItemFrame.class, Keys.ROTATION);
    }

    @Override
    protected boolean set(EntityItemFrame entity, Rotation value) {
        entity.func_82336_g(value.getAngle() / 45);
        return true;
    }

    @Override
    protected Optional<Rotation> getVal(EntityItemFrame entity) {
        return Optional.of(SpongeImpl.getGame().getRegistry().getRotationFromDegree(entity.func_82333_j() * 45).get());
    }

    @Override
    protected ImmutableValue<Rotation> constructImmutableValue(Rotation value) {
        return ImmutableSpongeValue.cachedOf(Keys.ROTATION, Rotations.BOTTOM, value);
    }

    @Override
    protected RotationalData createManipulator() {
        return new SpongeRotationalData();
    }

    @Override
    protected Value<Rotation> constructValue(Rotation actualValue) {
        return new SpongeValue<Rotation>(Keys.ROTATION, Rotations.BOTTOM, actualValue);
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

