/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import net.minecraft.entity.Entity;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableVelocityData;
import org.spongepowered.api.data.manipulator.mutable.entity.VelocityData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeVelocityData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.util.Constants;

public class VelocityDataProcessor
extends AbstractEntitySingleDataProcessor<Entity, Vector3d, Value<Vector3d>, VelocityData, ImmutableVelocityData> {
    public VelocityDataProcessor() {
        super(Entity.class, Keys.VELOCITY);
    }

    @Override
    protected VelocityData createManipulator() {
        return new SpongeVelocityData();
    }

    @Override
    protected boolean set(Entity entity, Vector3d value) {
        ((EntityBridge)entity).bridge$setImplVelocity(value);
        return true;
    }

    @Override
    protected Optional<Vector3d> getVal(Entity entity) {
        return Optional.of(new Vector3d(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y));
    }

    @Override
    public Optional<VelocityData> fill(DataContainer container, VelocityData velocityData) {
        DataUtil.checkDataExists(container, Keys.VELOCITY.getQuery());
        DataView internalView = container.getView(Keys.VELOCITY.getQuery()).get();
        double x = DataUtil.getData(internalView, Constants.Sponge.VelocityData.VELOCITY_X, Double.class);
        double y = DataUtil.getData(internalView, Constants.Sponge.VelocityData.VELOCITY_Y, Double.class);
        double z = DataUtil.getData(internalView, Constants.Sponge.VelocityData.VELOCITY_Z, Double.class);
        return Optional.of(velocityData.set(Keys.VELOCITY, new Vector3d(x, y, z)));
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected Value<Vector3d> constructValue(Vector3d actualValue) {
        return new SpongeValue<Vector3d>(Keys.VELOCITY, Vector3d.ZERO, actualValue);
    }

    @Override
    protected ImmutableValue<Vector3d> constructImmutableValue(Vector3d value) {
        return new ImmutableSpongeValue<Vector3d>(Keys.VELOCITY, Vector3d.ZERO, value);
    }
}

