/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityFallingBlock;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFallingBlockData;
import org.spongepowered.api.data.manipulator.mutable.entity.FallingBlockData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFallingBlockData;
import org.spongepowered.common.data.processor.common.AbstractMultiDataSingleTargetProcessor;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.mixin.core.entity.item.EntityFallingBlockAccessor;

public class FallingBlockDataProcessor
extends AbstractMultiDataSingleTargetProcessor<EntityFallingBlockAccessor, FallingBlockData, ImmutableFallingBlockData> {
    public FallingBlockDataProcessor() {
        super(EntityFallingBlockAccessor.class);
    }

    @Override
    protected boolean doesDataExist(EntityFallingBlockAccessor entity) {
        return true;
    }

    @Override
    protected boolean set(EntityFallingBlockAccessor entity, Map<Key<?>, Object> keyValues) {
        entity.accessor$setFallHurtAmount(((Double)keyValues.get(Keys.FALL_DAMAGE_PER_BLOCK)).floatValue());
        entity.accessor$setFallHurtMax(((Double)keyValues.get(Keys.MAX_FALL_DAMAGE)).intValue());
        entity.accessor$setFallBlockState((IBlockState)keyValues.get(Keys.FALLING_BLOCK_STATE));
        entity.accessor$setDontSetAsBlock((Boolean)keyValues.get(Keys.CAN_PLACE_AS_BLOCK) == false);
        ((EntityFallingBlock)entity).field_145813_c = (Boolean)keyValues.get(Keys.CAN_DROP_AS_ITEM);
        entity.accessor$setFallTime((Integer)keyValues.get(Keys.FALL_TIME));
        entity.accessor$setHurtEntities((Boolean)keyValues.get(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES));
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityFallingBlockAccessor entity) {
        return ImmutableMap.builder().put(Keys.FALL_DAMAGE_PER_BLOCK, (Object)entity.accessor$getFallHurtAmount()).put(Keys.MAX_FALL_DAMAGE, (Object)entity.accessor$getFallHurtMax()).put(Keys.FALLING_BLOCK_STATE, (Object)entity.accessor$getFallBlockState()).put(Keys.CAN_PLACE_AS_BLOCK, (Object)(!entity.accessor$getDontSetAsBlock() ? 1 : 0)).put(Keys.CAN_DROP_AS_ITEM, (Object)((EntityFallingBlock)entity).field_145813_c).put(Keys.FALL_TIME, (Object)entity.accessor$getFallTime()).put(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, (Object)entity.accessor$getHurtEntities()).build();
    }

    @Override
    protected FallingBlockData createManipulator() {
        return new SpongeFallingBlockData();
    }

    @Override
    public Optional<FallingBlockData> fill(DataContainer container, FallingBlockData fallingBlockData) {
        fallingBlockData.set(Keys.FALL_DAMAGE_PER_BLOCK, DataUtil.getData(container, Keys.FALL_DAMAGE_PER_BLOCK));
        fallingBlockData.set(Keys.MAX_FALL_DAMAGE, DataUtil.getData(container, Keys.MAX_FALL_DAMAGE));
        fallingBlockData.set(Keys.FALLING_BLOCK_STATE, DataUtil.getData(container, Keys.FALLING_BLOCK_STATE));
        fallingBlockData.set(Keys.CAN_PLACE_AS_BLOCK, DataUtil.getData(container, Keys.CAN_PLACE_AS_BLOCK));
        fallingBlockData.set(Keys.CAN_DROP_AS_ITEM, DataUtil.getData(container, Keys.CAN_DROP_AS_ITEM));
        fallingBlockData.set(Keys.FALL_TIME, DataUtil.getData(container, Keys.FALL_TIME));
        fallingBlockData.set(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, DataUtil.getData(container, Keys.FALLING_BLOCK_CAN_HURT_ENTITIES));
        return Optional.of(fallingBlockData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

