/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.tileentity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityChest;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.manipulator.mutable.block.ConnectedDirectionData;
import org.spongepowered.api.util.Direction;
import org.spongepowered.common.data.manipulator.mutable.block.SpongeConnectedDirectionData;
import org.spongepowered.common.data.processor.common.AbstractTileEntityDataProcessor;

public class TileConnectedDirectionDataProcessor
extends AbstractTileEntityDataProcessor<TileEntityChest, ConnectedDirectionData, ImmutableConnectedDirectionData> {
    public TileConnectedDirectionDataProcessor() {
        super(TileEntityChest.class);
    }

    @Override
    public Optional<ConnectedDirectionData> fill(DataContainer container, ConnectedDirectionData m) {
        Optional<List<?>> dirs = container.getList(Keys.CONNECTED_DIRECTIONS.getQuery());
        if (dirs.isPresent()) {
            m.set(Keys.CONNECTED_DIRECTIONS, Sets.newHashSet(dirs.get()));
            return Optional.of(m);
        }
        return Optional.empty();
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }

    @Override
    protected boolean doesDataExist(TileEntityChest chest) {
        chest.func_145979_i();
        return chest.field_145991_k != null || chest.field_145990_j != null || chest.field_145992_i != null || chest.field_145988_l != null;
    }

    @Override
    protected boolean set(TileEntityChest chest, Map<Key<?>, Object> keyValues) {
        return false;
    }

    @Override
    protected Map<Key<?>, ?> getValues(TileEntityChest chest) {
        HashMap values = Maps.newHashMap();
        HashSet directions = Sets.newHashSet();
        values.put(Keys.CONNECTED_DIRECTIONS, directions);
        chest.func_145979_i();
        if (chest.field_145992_i != null) {
            values.put(Keys.CONNECTED_NORTH, true);
            directions.add(Direction.NORTH);
        }
        if (chest.field_145990_j != null) {
            values.put(Keys.CONNECTED_EAST, true);
            directions.add(Direction.EAST);
        }
        if (chest.field_145988_l != null) {
            values.put(Keys.CONNECTED_SOUTH, true);
            directions.add(Direction.SOUTH);
        }
        if (chest.field_145991_k != null) {
            values.put(Keys.CONNECTED_WEST, true);
            directions.add(Direction.WEST);
        }
        return values;
    }

    @Override
    protected ConnectedDirectionData createManipulator() {
        return new SpongeConnectedDirectionData();
    }
}

