/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import com.google.common.collect.ImmutableList;
import java.util.Optional;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.ValueProcessor;

public final class ValueProcessorDelegate<E, V extends BaseValue<E>>
implements ValueProcessor<E, V> {
    private final Key<V> key;
    private final ImmutableList<ValueProcessor<E, V>> processors;

    public ValueProcessorDelegate(Key<V> key, ImmutableList<ValueProcessor<E, V>> processors) {
        this.key = key;
        this.processors = processors;
    }

    @Override
    public Key<? extends BaseValue<E>> getKey() {
        return this.key;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Optional<E> getValueFromContainer(ValueContainer<?> container) {
        for (ValueProcessor processor : this.processors) {
            Optional optional;
            if (!processor.supports(container) || !(optional = processor.getValueFromContainer(container)).isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public Optional<V> getApiValueFromContainer(ValueContainer<?> container) {
        for (ValueProcessor processor : this.processors) {
            Optional optional;
            if (!processor.supports(container) || !(optional = processor.getApiValueFromContainer(container)).isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public boolean supports(ValueContainer<?> container) {
        for (ValueProcessor processor : this.processors) {
            if (!processor.supports(container)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataTransactionResult offerToStore(ValueContainer<?> container, E value) {
        for (ValueProcessor processor : this.processors) {
            DataTransactionResult result;
            if (!processor.supports(container) || (result = processor.offerToStore(container, value)).getType().equals((Object)DataTransactionResult.Type.FAILURE)) continue;
            return result;
        }
        for (ValueProcessor processor : this.processors) {
            ImmutableValue<E> rejectedValue;
            Optional currentValueOptional;
            if (!processor.supports(container) || !(currentValueOptional = processor.getApiValueFromContainer(container)).isPresent()) continue;
            BaseValue currentValue = (BaseValue)currentValueOptional.get();
            if (currentValue instanceof Value) {
                Value mutableCurrentValue = (Value)currentValue;
                mutableCurrentValue.set(value);
                rejectedValue = mutableCurrentValue.asImmutable();
            } else {
                ImmutableValue immutableCurrentValue = (ImmutableValue)currentValue;
                rejectedValue = immutableCurrentValue.with(value);
            }
            return DataTransactionResult.failResult(rejectedValue);
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        for (ValueProcessor processor : this.processors) {
            DataTransactionResult result;
            if (!processor.supports(container) || (result = processor.removeFrom(container)).getType().equals((Object)DataTransactionResult.Type.FAILURE)) continue;
            return result;
        }
        return DataTransactionResult.failNoData();
    }
}

