/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.reflect.TypeToken;
import java.util.Objects;
import javax.annotation.Nullable;
import org.spongepowered.api.event.Event;

public final class EventType<T extends Event> {
    private final Class<T> eventType;
    @Nullable
    private final TypeToken<?> genericType;
    private int hashCode;

    EventType(Class<T> eventType, @Nullable TypeToken<?> genericType) {
        this.genericType = genericType;
        this.eventType = eventType;
    }

    public EventType(Class<T> eventType) {
        this(eventType, null);
    }

    public Class<T> getType() {
        return this.eventType;
    }

    @Nullable
    public TypeToken<?> getGenericType() {
        return this.genericType;
    }

    public String toString() {
        String value = this.eventType.getName();
        if (this.genericType != null) {
            value = value + "<" + this.genericType.toString() + ">";
        }
        return value;
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof EventType)) {
            return false;
        }
        EventType that = (EventType)o;
        return that.eventType.equals(this.eventType) && Objects.equals(that.genericType, this.genericType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.eventType, this.genericType);
        }
        return this.hashCode;
    }
}

