/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.event.tracking.phase.packet.inventory.BasicInventoryPacketState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.item.inventory.util.ContainerUtil;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;

public final class OpenInventoryState
extends BasicInventoryPacketState {
    @Override
    public void unwind(InventoryPacketContext context) {
        EntityPlayerMP player = context.getPacketPlayer();
        ItemStackSnapshot lastCursor = context.getCursor();
        ItemStackSnapshot newCursor = ItemStackUtil.snapshotOf(player.field_71071_by.func_70445_o());
        Transaction<ItemStackSnapshot> cursorTransaction = new Transaction<ItemStackSnapshot>(lastCursor, newCursor);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(player);
            InteractInventoryEvent.Open event = SpongeEventFactory.createInteractInventoryEventOpen(frame.getCurrentCause(), cursorTransaction, ContainerUtil.fromNative(player.field_71070_bA));
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                player.func_71053_j();
            } else {
                Transaction<ItemStackSnapshot> transaction = event.getCursorTransaction();
                if (!transaction.isValid()) {
                    PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, transaction.getOriginal());
                } else if (transaction.getCustom().isPresent()) {
                    PacketPhaseUtil.handleCustomCursor((EntityPlayer)player, transaction.getFinal());
                }
            }
        }
    }
}

