/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.entity.EntityBridge;
import org.spongepowered.common.bridge.tileentity.TileEntityBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;

class TileEntityTickPhaseState
extends LocationBasedTickPhaseState<TileEntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, TileEntityTickContext> TILE_ENTITY_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(org.spongepowered.api.block.tileentity.TileEntity.class).ifPresent(frame::pushCause));

    TileEntityTickPhaseState() {
    }

    @Override
    public TileEntityTickContext createNewContext() {
        return (TileEntityTickContext)((TileEntityTickContext)((TileEntityTickContext)new TileEntityTickContext(this).addEntityCaptures()).addEntityDropCaptures()).addBlockCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, TileEntityTickContext> getFrameModifier() {
        return this.TILE_ENTITY_MODIFIER;
    }

    @Override
    public boolean tracksEntitySpecificDrops() {
        return true;
    }

    @Override
    public boolean doesCaptureEntityDrops(TileEntityTickContext context) {
        return true;
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(org.spongepowered.api.block.tileentity.TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).getLocatableBlock();
    }

    @Override
    public void unwind(TileEntityTickContext context) {
        org.spongepowered.api.block.tileentity.TileEntity tickingTile = context.getSource(org.spongepowered.api.block.tileentity.TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            TrackingUtil.processBlockCaptures(context);
            frame.pushCause(tickingTile.getLocatableBlock());
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            context.getCapturedItemsSupplier().acceptAndClearIfNotEmpty(entities -> {
                ArrayList<Entity> capturedEntities = new ArrayList<Entity>();
                for (EntityItem entity : entities) {
                    capturedEntities.add((Entity)entity);
                }
                SpongeCommonEventFactory.callSpawnEntity(capturedEntities, context);
            });
            frame.removeContext(EventContextKeys.SPAWN_TYPE);
            context.getPerEntityItemEntityDropSupplier().acceptAndClearIfNotEmpty((id, item) -> {
                frame.popCause();
                ArrayList<Entity> entities = new ArrayList<Entity>();
                entities.add((Entity)item);
                Optional<Entity> entity = tickingTile.getWorld().getEntity((UUID)id);
                if (!entity.isPresent()) {
                    frame.pushCause(tickingTile);
                    frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
                    SpongeCommonEventFactory.callSpawnEntity(entities, context);
                    return;
                }
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
                Entity nestedEntity = entity.get();
                frame.pushCause(nestedEntity);
                frame.pushCause(tickingTile);
                SpongeCommonEventFactory.callSpawnEntityCustom(entities, context);
                ((EntityBridge)((Object)nestedEntity)).bridge$clearWrappedCaptureList();
            });
        }
    }

    @Override
    public boolean tracksTileEntityChanges(TileEntityTickContext currentContext) {
        return this.doesBulkBlockCapture(currentContext);
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, TileEntityTickContext context) {
        context.applyNotifierIfAvailable(explosionContext::notifier);
        context.applyOwnerIfAvailable(explosionContext::owner);
        org.spongepowered.api.block.tileentity.TileEntity tickingTile = context.getSource(org.spongepowered.api.block.tileentity.TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.source(tickingTile);
    }

    @Override
    public boolean spawnEntityOrCapture(TileEntityTickContext context, Entity entity, int chunkX, int chunkZ) {
        org.spongepowered.api.block.tileentity.TileEntity tickingTile = context.getSource(org.spongepowered.api.block.tileentity.TileEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        TileEntityBridge mixinTileEntity = (TileEntityBridge)((Object)tickingTile);
        if (!context.allowsEntityEvents() || !ShouldFire.SPAWN_ENTITY_EVENT) {
            return EntityUtil.processEntitySpawn(entity, EntityUtil.ENTITY_CREATOR_FUNCTION.apply(context));
        }
        if (entity instanceof EntityXPOrb) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(tickingTile.getLocatableBlock());
                frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.EXPERIENCE);
                context.addNotifierAndOwnerToCauseStack(frame);
                ArrayList<Entity> exp = new ArrayList<Entity>();
                exp.add(entity);
                boolean bl = SpongeCommonEventFactory.callSpawnEntity(exp, context);
                return bl;
            }
        }
        ArrayList<Entity> nonExpEntities = new ArrayList<Entity>(1);
        nonExpEntities.add(entity);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(tickingTile.getLocatableBlock());
            frame.addContext(EventContextKeys.SPAWN_TYPE, mixinTileEntity.bridge$getTickedSpawnType());
            context.addNotifierAndOwnerToCauseStack(frame);
            boolean bl = SpongeCommonEventFactory.callSpawnEntity(nonExpEntities, context);
            return bl;
        }
    }

    @Override
    public boolean getShouldCancelAllTransactions(TileEntityTickContext context, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent.Post postEvent, ListMultimap<BlockPos, BlockEventData> scheduledEvents, boolean noCancelledTransactions) {
        if (!postEvent.getTransactions().isEmpty()) {
            return postEvent.getTransactions().stream().anyMatch(transaction -> {
                BlockPos blockPos;
                BlockState state = ((BlockSnapshot)transaction.getOriginal()).getState();
                BlockType type = state.getType();
                boolean hasTile = SpongeImplHooks.hasBlockTileEntity((Block)type, (IBlockState)state);
                BlockPos pos = context.getSource(TileEntity.class).get().func_174877_v();
                if (pos.equals((Object)(blockPos = ((SpongeBlockSnapshot)transaction.getOriginal()).getBlockPos())) && !transaction.isValid()) {
                    return true;
                }
                if (!hasTile && !transaction.getIntermediary().isEmpty()) {
                    return transaction.getIntermediary().stream().anyMatch(inter -> {
                        BlockState iterState = inter.getState();
                        BlockType interType = state.getType();
                        return SpongeImplHooks.hasBlockTileEntity((Block)interType, (IBlockState)iterState);
                    });
                }
                return hasTile;
            });
        }
        return false;
    }

    @Override
    public boolean doesCaptureNeighborNotifications(TileEntityTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBulkBlockCapture(TileEntityTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBlockEventTracking(TileEntityTickContext context) {
        return context.allowsBlockEvents();
    }

    @Override
    public boolean hasSpecificBlockProcess(TileEntityTickContext context) {
        return true;
    }
}

