/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.inventory.archetype;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.api.event.item.inventory.InteractInventoryEvent;
import org.spongepowered.api.item.inventory.InventoryArchetype;
import org.spongepowered.api.item.inventory.InventoryProperty;
import org.spongepowered.common.item.inventory.archetype.CompositeInventoryArchetype;

public class SpongeInventoryArchetypeBuilder
implements InventoryArchetype.Builder {
    private List<InventoryArchetype> types = new ArrayList<InventoryArchetype>();
    private Map<String, InventoryProperty<String, ?>> properties = new HashMap();
    private Set<Class<? extends InteractInventoryEvent>> events = new ReferenceOpenHashSet();
    private CompositeInventoryArchetype.ContainerProvider containerProvider;

    @Override
    public SpongeInventoryArchetypeBuilder property(InventoryProperty<String, ?> property) {
        this.properties.put((String)property.getKey(), property);
        return this;
    }

    @Override
    public SpongeInventoryArchetypeBuilder with(InventoryArchetype archetype) {
        this.types.add(archetype);
        return this;
    }

    @Override
    public SpongeInventoryArchetypeBuilder with(InventoryArchetype ... archetypes) {
        Collections.addAll(this.types, archetypes);
        return this;
    }

    @Override
    public SpongeInventoryArchetypeBuilder from(InventoryArchetype value) {
        if (value instanceof CompositeInventoryArchetype) {
            this.types.addAll(value.getChildArchetypes());
            this.properties.putAll(value.getProperties());
        }
        return this;
    }

    public SpongeInventoryArchetypeBuilder container(CompositeInventoryArchetype.ContainerProvider containerProvider) {
        this.containerProvider = containerProvider;
        return this;
    }

    @Override
    public SpongeInventoryArchetypeBuilder reset() {
        this.types.clear();
        this.properties.clear();
        this.events.clear();
        return this;
    }

    @Override
    public InventoryArchetype build(String id, String name) {
        return new CompositeInventoryArchetype(id, name, this.types, this.properties, this.containerProvider);
    }
}

