/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.item.crafting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.crafting.FurnaceRecipes;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipe;
import org.spongepowered.api.item.recipe.smelting.SmeltingRecipeRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.registry.SpongeAdditionalCatalogRegistryModule;

@Mixin(value={FurnaceRecipes.class})
public abstract class FurnaceRecipesMixin_API
implements SmeltingRecipeRegistry {
    private final Map<String, SmeltingRecipe> recipesById = new HashMap<String, SmeltingRecipe>();
    private final List<SmeltingRecipe> customRecipes = new ArrayList<SmeltingRecipe>();
    private final List<SmeltingRecipe> notCustomRecipes = new ArrayList<SmeltingRecipe>();

    @Override
    public Optional<SmeltingRecipe> findMatchingRecipe(ItemStackSnapshot ingredient) {
        Preconditions.checkNotNull((Object)ingredient, (Object)"ingredient");
        for (SmeltingRecipe customRecipe : this.customRecipes) {
            if (!customRecipe.isValid(ingredient)) continue;
            return Optional.of(customRecipe);
        }
        for (SmeltingRecipe recipe : this.notCustomRecipes) {
            if (!recipe.isValid(ingredient)) continue;
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    @Override
    public void register(SmeltingRecipe recipe) {
        ((SpongeAdditionalCatalogRegistryModule)((Object)this)).registerAdditionalCatalog(recipe);
    }

    @Override
    public Optional<SmeltingRecipe> getById(String id) {
        Preconditions.checkNotNull((Object)id, (Object)"id");
        return Optional.ofNullable(this.recipesById.get(id));
    }

    @Override
    public Collection<SmeltingRecipe> getAll() {
        return ImmutableList.copyOf(this.recipesById.values());
    }
}

