/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeacon;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockEndGateway;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockMobSpawner;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.entity.ConstructEntityEvent;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.bridge.TimingBridge;
import org.spongepowered.common.bridge.TrackableBridge;
import org.spongepowered.common.bridge.block.BlockBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.category.BlockTrackerCategory;
import org.spongepowered.common.config.category.BlockTrackerModCategory;
import org.spongepowered.common.config.type.TrackerConfig;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.SpongeProxyBlockAccess;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.registry.type.BlockTypeRegistryModule;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;

@NonnullByDefault
@Mixin(value={Block.class})
public abstract class BlockMixin
implements BlockBridge,
TrackableBridge,
TimingBridge {
    private final boolean impl$isVanilla = this.getClass().getName().startsWith("net.minecraft.");
    private boolean impl$hasCollideLogic;
    private boolean impl$hasCollideWithStateLogic;
    private boolean impl$shouldFireBlockEvents = true;
    @Nullable
    private Timing impl$timing;
    private boolean impl$allowsBlockBulkCapture = true;
    private boolean impl$allowsEntityBulkCapture = true;
    private boolean impl$allowsBlockEventCreation = true;
    private boolean impl$allowsEntityEventCreation = true;
    private boolean impl$hasNeighborOverride = false;
    @Shadow
    @Final
    protected BlockStateContainer field_176227_L;
    @Nullable
    private PhaseContext<?> data = null;

    @Shadow
    public abstract String func_149739_a();

    @Shadow
    public abstract Material func_149688_o(IBlockState var1);

    @Shadow
    public abstract IBlockState shadow$func_176223_P();

    @Shadow
    public abstract void func_176226_b(net.minecraft.world.World var1, BlockPos var2, IBlockState var3, int var4);

    @Shadow
    public abstract BlockStateContainer func_176194_O();

    @Shadow
    protected abstract Block func_149675_a(boolean var1);

    @Inject(method={"registerBlock(ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/block/Block;)V"}, at={@At(value="RETURN")})
    private static void onRegisterBlock(int id, ResourceLocation location, Block block, CallbackInfo ci) {
        BlockTypeRegistryModule.getInstance().registerFromGameData(location.toString(), (BlockType)block);
    }

    @Override
    public boolean bridge$supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return false;
    }

    @Override
    public Optional<BlockState> bridge$getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        return Optional.empty();
    }

    @Override
    public <E> Optional<BlockState> bridge$getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        return Optional.empty();
    }

    @Override
    public List<ImmutableDataManipulator<?, ?>> bridge$getManipulators(IBlockState blockState) {
        return ImmutableList.of();
    }

    @Override
    public ImmutableMap<Class<? extends Property<?, ?>>, Property<?, ?>> bridge$getProperties(IBlockState blockState) {
        return this.populateSpongeProperties(ImmutableMap.builder(), blockState).build();
    }

    private ImmutableMap.Builder<Class<? extends Property<?, ?>>, Property<?, ?>> populateSpongeProperties(ImmutableMap.Builder<Class<? extends Property<?, ?>>, Property<?, ?>> builder, IBlockState blockState) {
        for (Property<?, ?> property : SpongeImpl.getPropertyRegistry().getPropertiesFor((BlockState)blockState)) {
            builder.put(property.getClass(), property);
        }
        return builder;
    }

    @Inject(method={"dropBlockAsItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkBlockDropForTransactions(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, int fortune, CallbackInfo ci) {
        if (((WorldBridge)worldIn).bridge$isFake()) {
            return;
        }
        SpongeProxyBlockAccess proxyAccess = ((WorldServerBridge)worldIn).bridge$getProxyAccess();
        if (proxyAccess.hasProxy() && proxyAccess.isProcessingTransactionWithNextHavingBreak(pos, state)) {
            ci.cancel();
        }
    }

    @Inject(method={"spawnAsEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/item/EntityItem;setDefaultPickupDelay()V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILSOFT, cancellable=true)
    private static void impl$attemptCaptureOrAllowSpawn(net.minecraft.world.World worldIn, BlockPos pos, ItemStack stack, CallbackInfo ci, float unused, double xOffset, double yOffset, double zOffset, EntityItem toSpawn) {
        PhaseContext<?> context = PhaseTracker.getInstance().getCurrentContext();
        if (context.allowsBulkEntityCaptures() && context.allowsBlockPosCapturing()) {
            context.getCaptureBlockPos().setPos(pos);
            worldIn.func_72838_d((Entity)toSpawn);
            context.getCaptureBlockPos().setPos(null);
            ci.cancel();
        }
    }

    @Inject(method={"spawnAsEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private static void impl$checkMainThreadAndRestoring(net.minecraft.world.World worldIn, BlockPos pos, ItemStack stack, CallbackInfo ci) {
        if (!SpongeImplHooks.isMainThread() || PhaseTracker.getInstance().getCurrentState().isRestoring()) {
            ci.cancel();
        }
    }

    @Inject(method={"spawnAsEntity"}, at={@At(value="NEW", target="net/minecraft/entity/item/EntityItem")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT, require=0, expect=0)
    private static void impl$throwConstructPreEvent(net.minecraft.world.World worldIn, BlockPos pos, ItemStack stack, CallbackInfo ci, float unused, double xOffset, double yOffset, double zOffset) {
        if (!ShouldFire.CONSTRUCT_ENTITY_EVENT_PRE) {
            return;
        }
        double xPos = (double)pos.func_177958_n() + xOffset;
        double yPos = (double)pos.func_177956_o() + yOffset;
        double zPos = (double)pos.func_177952_p() + zOffset;
        Transform<World> position = new Transform<World>((World)worldIn, new Vector3d(xPos, yPos, zPos));
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(worldIn.func_180495_p(pos));
            ConstructEntityEvent.Pre eventPre = SpongeEventFactory.createConstructEntityEventPre(frame.getCurrentCause(), EntityTypes.ITEM, position);
            SpongeImpl.postEvent(eventPre);
            if (eventPre.isCancelled()) {
                ci.cancel();
            }
        }
    }

    @Inject(method={"dropBlockAsItemWithChance"}, at={@At(value="HEAD")}, cancellable=true)
    private void onDropBlockAsItemWithChanceHead(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, float chance, int fortune, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake() && !SpongeImplHooks.isRestoringBlocks(worldIn)) {
            boolean shouldEnterBlockDropPhase;
            if (PhaseTracker.getInstance().getCurrentState().isRestoring()) {
                ci.cancel();
                return;
            }
            WorldServerBridge mixinWorld = (WorldServerBridge)worldIn;
            PhaseTracker phaseTracker = PhaseTracker.getInstance();
            IPhaseState<?> currentState = phaseTracker.getCurrentState();
            PhaseContext<?> currentContext = phaseTracker.getCurrentContext();
            boolean bl = shouldEnterBlockDropPhase = !currentContext.isCapturingBlockItemDrops() && !currentState.alreadyProcessingBlockItemDrops() && !currentState.isWorldGeneration();
            if (shouldEnterBlockDropPhase) {
                Object context = ((PhaseContext)BlockPhase.State.BLOCK_DROP_ITEMS.createPhaseContext()).source(mixinWorld.bridge$createSnapshot(state, state, pos, BlockChangeFlags.PHYSICS_OBSERVER));
                currentContext.applyNotifierIfAvailable(arg_0 -> context.notifier(arg_0));
                currentContext.applyOwnerIfAvailable(arg_0 -> context.owner(arg_0));
                ((PhaseContext)context).buildAndSwitch();
                this.data = context;
            }
        }
    }

    @Inject(method={"dropBlockAsItemWithChance"}, at={@At(value="RETURN")}, cancellable=true)
    private void onDropBlockAsItemWithChanceReturn(net.minecraft.world.World worldIn, BlockPos pos, IBlockState state, float chance, int fortune, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake() && !SpongeImplHooks.isRestoringBlocks(worldIn)) {
            if (this.data == null) {
                return;
            }
            this.data.close();
            this.data = null;
        }
    }

    @Override
    public boolean bridge$isVanilla() {
        return this.impl$isVanilla;
    }

    @Override
    public boolean bridge$hasCollideLogic() {
        return this.impl$hasCollideLogic;
    }

    @Override
    public boolean bridge$hasCollideWithStateLogic() {
        return this.impl$hasCollideWithStateLogic;
    }

    @Override
    public boolean bridge$hasNeighborChangedLogic() {
        return this.impl$hasNeighborOverride;
    }

    @Override
    public Timing bridge$getTimingsHandler() {
        if (this.impl$timing == null) {
            this.impl$timing = SpongeTimings.getBlockTiming((Block)this);
        }
        return this.impl$timing;
    }

    @Override
    public boolean bridge$allowsBlockBulkCapture() {
        return this.impl$allowsBlockBulkCapture;
    }

    @Override
    public boolean bridge$allowsEntityBulkCapture() {
        return this.impl$allowsEntityBulkCapture;
    }

    @Override
    public boolean bridge$allowsBlockEventCreation() {
        return this.impl$allowsBlockEventCreation;
    }

    @Override
    public boolean bridge$allowsEntityEventCreation() {
        return this.impl$allowsEntityEventCreation;
    }

    @Override
    public void bridge$refreshTrackerStates() {
    }

    @Override
    public boolean bridge$shouldFireBlockEvents() {
        return this.impl$shouldFireBlockEvents;
    }

    @Override
    public void bridge$initializeTrackerState() {
        BlockTrackerModCategory blockTrackerModCat;
        String name;
        BlockTrackerCategory blockTrackerCat;
        SpongeConfig<TrackerConfig> trackerConfigAdapter;
        block16: {
            Class<?> clazz;
            Class[] argTypes;
            String mapping;
            trackerConfigAdapter = SpongeImpl.getTrackerConfigAdapter();
            blockTrackerCat = trackerConfigAdapter.getConfig().getBlockTracker();
            Object[] ids = ((BlockType)((Object)this)).getId().split(":");
            if (ids.length != 2) {
                PrettyPrinter printer = new PrettyPrinter(60).add("Malformatted Block ID discovered!").centre().hr().addWrapped(60, "Sponge has found a malformatted block id when trying to load configurations for the block id. The printed out block idis not originally from sponge, and should be brought up with themod developer as the registration for this block is not likelyto work with other systems and assumptions of having a properlyformatted block id.", new Object[0]).add("%s : %s", "Malformed ID", ((BlockType)((Object)this)).getId()).add("%s : %s", "Discovered id array", ids).add();
                String id = ids[0];
                ids = new String[]{"unknown", id};
                printer.add("Sponge will attempt to work around this by using the provided generated id:").add("%s : %s", "Generated ID", Arrays.toString(ids)).log(SpongeImpl.getLogger(), Level.WARN);
            }
            String modId = ids[0];
            name = ids[1];
            blockTrackerModCat = blockTrackerCat.getModMappings().get(modId);
            if (blockTrackerModCat == null) {
                blockTrackerModCat = new BlockTrackerModCategory();
                blockTrackerCat.getModMappings().put(modId, blockTrackerModCat);
            }
            if ((Block)this instanceof BlockMobSpawner || (Block)this instanceof BlockEnderChest || (Block)this instanceof BlockChest || (Block)this instanceof BlockShulkerBox || (Block)this instanceof BlockEndGateway || (Block)this instanceof BlockBeacon) {
                this.impl$shouldFireBlockEvents = false;
            }
            this.impl$hasCollideLogic = true;
            this.impl$hasCollideWithStateLogic = true;
            try {
                mapping = SpongeImplHooks.isDeobfuscatedEnvironment() ? "onEntityWalk" : "func_176199_a";
                argTypes = new Class[]{net.minecraft.world.World.class, BlockPos.class, Entity.class};
                clazz = this.getClass().getMethod(mapping, argTypes).getDeclaringClass();
                if (clazz.equals(Block.class)) {
                    this.impl$hasCollideLogic = false;
                }
            }
            catch (NoClassDefFoundError err) {
                this.impl$hasCollideLogic = !this.getClass().equals(Block.class);
            }
            catch (Throwable err) {
                // empty catch block
            }
            try {
                mapping = SpongeImplHooks.isDeobfuscatedEnvironment() ? "onEntityCollision" : "func_180634_a";
                argTypes = new Class[]{net.minecraft.world.World.class, BlockPos.class, IBlockState.class, Entity.class};
                clazz = this.getClass().getMethod(mapping, argTypes).getDeclaringClass();
                if (clazz.equals(Block.class)) {
                    this.impl$hasCollideWithStateLogic = false;
                }
            }
            catch (NoClassDefFoundError err) {
                this.impl$hasCollideWithStateLogic = !this.getClass().equals(Block.class);
            }
            catch (Throwable err) {
                // empty catch block
            }
            try {
                mapping = SpongeImplHooks.isDeobfuscatedEnvironment() ? "neighborChanged" : "func_189540_a";
                argTypes = new Class[]{IBlockState.class, net.minecraft.world.World.class, BlockPos.class, Block.class, BlockPos.class};
                clazz = this.getClass().getMethod(mapping, argTypes).getDeclaringClass();
                this.impl$hasNeighborOverride = !clazz.equals(Block.class);
            }
            catch (Throwable e) {
                if (!(e instanceof NoClassDefFoundError)) break block16;
                boolean bl = this.impl$hasNeighborOverride = !this.getClass().equals(Block.class);
            }
        }
        if (!blockTrackerModCat.isEnabled()) {
            this.impl$allowsBlockBulkCapture = false;
            this.impl$allowsEntityBulkCapture = false;
            this.impl$allowsBlockEventCreation = false;
            this.impl$allowsEntityEventCreation = false;
            blockTrackerModCat.getBlockBulkCaptureMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> this.impl$allowsBlockBulkCapture);
            blockTrackerModCat.getEntityBulkCaptureMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> this.impl$allowsEntityBulkCapture);
            blockTrackerModCat.getBlockEventCreationMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> this.impl$allowsBlockEventCreation);
            blockTrackerModCat.getEntityEventCreationMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> this.impl$allowsEntityEventCreation);
        } else {
            this.impl$allowsBlockBulkCapture = blockTrackerModCat.getBlockBulkCaptureMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> true);
            this.impl$allowsEntityBulkCapture = blockTrackerModCat.getEntityBulkCaptureMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> true);
            this.impl$allowsBlockEventCreation = blockTrackerModCat.getBlockEventCreationMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> true);
            this.impl$allowsEntityEventCreation = blockTrackerModCat.getEntityEventCreationMap().computeIfAbsent(name.toLowerCase(Locale.ENGLISH), k -> true);
        }
        if (blockTrackerCat.autoPopulateData()) {
            trackerConfigAdapter.save();
        }
    }
}

