/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import com.flowpowered.math.vector.Vector3d;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.entity.item.EntityEnderCrystalBridge;
import org.spongepowered.common.bridge.explosives.ExplosiveBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={EntityEnderCrystal.class})
public abstract class EntityEnderCrystalMixin
extends EntityMixin
implements ExplosiveBridge,
EntityEnderCrystalBridge {
    private int explosionStrength = 6;

    @Override
    public Optional<Integer> bridge$getExplosionRadius() {
        return Optional.of(this.explosionStrength);
    }

    @Override
    public void bridge$setExplosionRadius(@Nullable Integer radius) {
        this.explosionStrength = radius == null ? 6 : radius;
    }

    @Redirect(method={"attackEntityFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;createExplosion(Lnet/minecraft/entity/Entity;DDDFZ)Lnet/minecraft/world/Explosion;"))
    @Nullable
    private net.minecraft.world.Explosion impl$throwEventWithEntity(World world, @Nullable Entity nil, double x, double y, double z, float strength, boolean smoking, DamageSource source, float damage) {
        return this.bridge$ThrowEventWithDetonation(world, nil, x, y, z, smoking, source);
    }

    @Override
    @Nullable
    public net.minecraft.world.Explosion bridge$ThrowEventWithDetonation(World world, @Nullable Entity nil, double x, double y, double z, boolean smoking, @Nullable DamageSource source) {
        CauseStackManager causeStackManager = Sponge.getCauseStackManager();
        try (CauseStackManager.StackFrame frame = causeStackManager.pushCauseFrame();){
            frame.pushCause(this);
            if (source != null) {
                frame.pushCause(source);
            }
            net.minecraft.world.Explosion explosion = SpongeCommonEventFactory.detonateExplosive(this, Explosion.builder().location(new Location<org.spongepowered.api.world.World>((org.spongepowered.api.world.World)world, new Vector3d(x, y, z))).radius(this.explosionStrength).shouldPlaySmoke(smoking)).orElse(null);
            return explosion;
        }
    }
}

