/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.entitycollisions;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.bridge.world.WorldServerBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.plugin.entitycollisions.interfaces.CollisionsCapability;

@Mixin(value={Chunk.class})
public abstract class ChunkMixin_Collisions {
    @Shadow
    @Final
    private World field_76637_e;

    @Inject(method={"getEntitiesWithinAABBForEntity"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    private void collisionsImpl$checkForCollisionRules(Entity entityIn, AxisAlignedBB aabb, List<Entity> listToFill, Predicate<? super Entity> predicate, CallbackInfo ci) {
        if (((WorldBridge)this.field_76637_e).bridge$isFake() || entityIn == null || entityIn instanceof EntityPlayer || entityIn.func_70021_al() != null) {
            return;
        }
        if (!this.collisionsImpl$allowEntityCollision(listToFill)) {
            ci.cancel();
        }
    }

    @Inject(method={"getEntitiesOfTypeWithinAABB"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", remap=false)}, cancellable=true)
    private <T extends Entity> void collisionsImpl$checkForCollisionRules(Class<? extends T> entityClass, AxisAlignedBB aabb, List<T> listToFill, Predicate<? super T> p_177430_4_, CallbackInfo ci) {
        if (this.field_76637_e.field_72995_K || EntityPlayer.class.isAssignableFrom(entityClass) || EntityItem.class == entityClass) {
            return;
        }
        if (!this.collisionsImpl$allowEntityCollision(listToFill)) {
            ci.cancel();
        }
    }

    private <T extends Entity> boolean collisionsImpl$allowEntityCollision(List<T> listToFill) {
        if (this.field_76637_e instanceof WorldServerBridge) {
            if (!PhaseTracker.getInstance().getCurrentState().isCollision()) {
                return true;
            }
            PhaseContext<?> phaseContext = PhaseTracker.getInstance().getCurrentContext();
            Object source = phaseContext.getSource();
            if (!(source instanceof CollisionsCapability)) {
                return true;
            }
            if (listToFill.size() < this.field_76637_e.func_82736_K().func_180263_c("maxEntityCramming")) {
                return true;
            }
            CollisionsCapability capability = (CollisionsCapability)source;
            if (capability.collision$requiresCollisionsCacheRefresh()) {
                capability.collision$initializeCollisionState(this.field_76637_e);
                capability.collision$requiresCollisionsCacheRefresh(false);
            }
            return capability.collision$getMaxCollisions() < 0 || listToFill.size() < capability.collision$getMaxCollisions();
        }
        return true;
    }
}

