/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.world.schematic;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.extent.MutableBiomeVolume;
import org.spongepowered.api.world.extent.worker.MutableBlockVolumeWorker;
import org.spongepowered.api.world.schematic.BlockPalette;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.common.world.extent.worker.SpongeMutableBlockVolumeWorker;
import org.spongepowered.common.world.schematic.SpongeArchetypeVolume;
import org.spongepowered.common.world.schematic.SpongeSchematicBuilder;

public class SpongeSchematic
extends SpongeArchetypeVolume
implements Schematic {
    @Nullable
    private final MutableBiomeVolume biomes;
    private final Palette<BiomeType> biomePalette;
    @Nullable
    private final Palette<BlockState> overriddenBlockPalette;
    private DataView metadata;

    SpongeSchematic(SpongeSchematicBuilder builder) {
        super(builder.backingVolume, builder.tiles, builder.entities);
        this.metadata = builder.metadata;
        this.biomes = builder.biomeVolume;
        this.biomePalette = builder.biomePalette;
        this.overriddenBlockPalette = this.getPalette().getType() != builder.blockPalette.getType() ? builder.blockPalette : null;
    }

    @Override
    public void apply(Location<World> location, BlockChangeFlag changeFlag) {
        super.apply(location, changeFlag);
        if (this.biomes != null) {
            this.biomes.getBiomeWorker().iterate((v, x, y, z) -> ((World)location.getExtent()).setBiome(x + location.getBlockX(), y + location.getBlockY(), z + location.getBlockZ(), v.getBiome(x, y, z)));
        }
    }

    @Override
    public BlockPalette getPalette() {
        return (BlockPalette)(this.overriddenBlockPalette == null ? super.getPalette() : this.overriddenBlockPalette);
    }

    @Override
    public DataView getMetadata() {
        return this.metadata;
    }

    @Override
    public MutableBlockVolumeWorker<Schematic> getBlockWorker() {
        return new SpongeMutableBlockVolumeWorker<Schematic>(this);
    }

    @Override
    public Palette<BlockState> getBlockPalette() {
        return this.getPalette();
    }

    @Override
    public Palette<BiomeType> getBiomePalette() {
        return this.biomePalette;
    }

    @Override
    public Optional<MutableBiomeVolume> getBiomes() {
        return Optional.ofNullable(this.biomes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeSchematic that = (SpongeSchematic)o;
        return Objects.equals(this.biomes, that.biomes) && this.biomePalette.equals(that.biomePalette) && Objects.equals(this.overriddenBlockPalette, that.overriddenBlockPalette) && this.metadata.equals(that.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.biomes, this.biomePalette, this.overriddenBlockPalette, this.metadata);
    }
}

