/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.client;

import java.time.Instant;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.LoadingScreenRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiOverlayDebug;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.server.integrated.IntegratedServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TranslatableText;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.server.integrated.IntegratedServerBridge;
import org.spongepowered.common.world.storage.SpongePlayerDataHandler;
import org.spongepowered.mod.bridge.client.MinecraftBridge_Forge;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin_Forge
implements MinecraftBridge_Forge {
    @Shadow
    private LanguageManager field_135017_as;
    @Shadow
    private IntegratedServer field_71437_Z;
    @Shadow
    private long field_71419_L;
    private GuiOverlayDebug debugGui;
    private Text kickMessage;
    private boolean isNewSave;

    @Inject(method={"launchIntegratedServer"}, at={@At(value="NEW", args={"class=net/minecraft/world/storage/WorldInfo"}, ordinal=0)})
    private void forgeImpl$setNewSave(CallbackInfo ci) {
        this.isNewSave = true;
    }

    @Redirect(method={"launchIntegratedServer"}, at=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/Minecraft;integratedServer:Lnet/minecraft/server/integrated/IntegratedServer;", ordinal=0))
    private void forgeImpl$MarkForNewSaves(Minecraft minecraft, IntegratedServer server) {
        this.field_71437_Z = server;
        if (this.isNewSave) {
            ((IntegratedServerBridge)this.field_71437_Z).bridge$markNewSave();
        }
        this.isNewSave = false;
    }

    @Override
    public void forgeBridge$setDebugGui(GuiOverlayDebug debugGui) {
        this.debugGui = debugGui;
    }

    @Override
    public GuiOverlayDebug forgeBridge$getDebugGui() {
        return this.debugGui;
    }

    @Override
    public Text forgeBridge$getSinglePlayerKickMessage() {
        return this.kickMessage;
    }

    @Override
    public void forgeBridge$setSinglePlayerKickMessage(Text text) {
        this.kickMessage = text;
    }

    @Inject(method={"shutdownMinecraftApplet"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fml/common/asm/transformers/TerminalTransformer$ExitVisitor;systemExitCalled(I)V", remap=false)})
    @Dynamic
    private void onShutdownDelegate(CallbackInfo ci) {
        SpongeImpl.postShutdownEvents();
    }

    @Inject(method={"loadWorld(Lnet/minecraft/client/multiplayer/WorldClient;Ljava/lang/String;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/entity/EntityPlayerSP;preparePlayerToSpawn()V", shift=At.Shift.AFTER)})
    private void onSpawn(WorldClient client, String name, CallbackInfo callbackInfo) {
        try {
            EntityPlayerSP player;
            UUID uuid;
            Optional<Instant> joined;
            if (Sponge.isServerAvailable() && SpongeImpl.getServer().func_71264_H() && !(joined = SpongePlayerDataHandler.getFirstJoined(uuid = (player = Minecraft.func_71410_x().field_71439_g).func_110124_au())).isPresent()) {
                Instant newJoined = Instant.now();
                SpongePlayerDataHandler.setPlayerInfo(uuid, newJoined, newJoined);
            }
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Could not retrieve the player instance or single player instance to get the join data.", (Throwable)e);
        }
    }

    @Redirect(method={"loadWorld(Lnet/minecraft/client/multiplayer/WorldClient;Ljava/lang/String;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/LoadingScreenRenderer;displayLoadingString(Ljava/lang/String;)V", ordinal=0))
    private void forgeImpl$updateLoadMessage(LoadingScreenRenderer loadingScreen, String message) {
        if (this.kickMessage == null) {
            loadingScreen.func_73719_c(I18n.func_135052_a((String)"forge.client.shutdown.internal", (Object[])new Object[0]));
        } else {
            String loadingString = this.kickMessage instanceof TranslatableText ? ((TranslatableText)this.kickMessage).getTranslation().get(Locale.forLanguageTag(this.field_135017_as.func_135041_c().func_135034_a())) : TextSerializers.LEGACY_FORMATTING_CODE.serialize(this.kickMessage);
            loadingScreen.func_73719_c(loadingString);
            this.kickMessage = null;
        }
    }

    @Redirect(method={"runGameLoop"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;debugUpdateTime:J", opcode=181))
    private void forgeImpl$updateDebugTime(Minecraft this$0, long value) {
        this.field_71419_L = Minecraft.func_71386_F();
    }
}

