/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.common.MekanismFluids;
import mekanism.common.Upgrade;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityElectrolyticSeparator
extends TileEntityMachine
implements IFluidHandlerWrapper,
IComputerIntegration,
ISustainedData,
IGasHandler,
Upgrade.IUpgradeInfoHandler,
ITankManager,
IComparatorSupport {
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getWater", "getWaterNeeded", "getHydrogen", "getHydrogenNeeded", "getOxygen", "getOxygenNeeded"};
    public FluidTank fluidTank = new FluidTank(24000);
    public int MAX_GAS = 2400;
    public GasTank leftTank = new GasTank(this.MAX_GAS);
    public GasTank rightTank = new GasTank(this.MAX_GAS);
    public int output = 512;
    public TileEntityGasTank.GasMode dumpLeft = TileEntityGasTank.GasMode.IDLE;
    public TileEntityGasTank.GasMode dumpRight = TileEntityGasTank.GasMode.IDLE;
    public SeparatorRecipe cachedRecipe;
    public double clientEnergyUsed;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;
    private int currentRedstoneLevel;

    public TileEntityElectrolyticSeparator() {
        super("machine.electrolyticseparator", BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR, 4);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            SeparatorRecipe recipe;
            ChargeUtils.discharge(3, this);
            if (!((ItemStack)this.inventory.get(0)).func_190926_b() && RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe((ItemStack)this.inventory.get(0)) && FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
                this.fluidTank.fill(FluidContainerUtils.extractFluid(this.fluidTank, this, 0), true);
            }
            if (!((ItemStack)this.inventory.get(1)).func_190926_b() && this.leftTank.getStored() > 0) {
                this.leftTank.draw(GasUtils.addGas((ItemStack)this.inventory.get(1), this.leftTank.getGas()), true);
                MekanismUtils.saveChunk(this);
            }
            if (!((ItemStack)this.inventory.get(2)).func_190926_b() && this.rightTank.getStored() > 0) {
                this.rightTank.draw(GasUtils.addGas((ItemStack)this.inventory.get(2), this.rightTank.getGas()), true);
                MekanismUtils.saveChunk(this);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                boolean update = this.BASE_ENERGY_PER_TICK != recipe.energyUsage;
                this.BASE_ENERGY_PER_TICK = recipe.energyUsage;
                if (update) {
                    this.recalculateUpgradables(Upgrade.ENERGY);
                }
                int operations = this.operate(recipe);
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            int dumpAmount = 8 * (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
            this.handleTank(this.leftTank, this.dumpLeft, MekanismUtils.getLeft(this.facing), dumpAmount);
            this.handleTank(this.rightTank, this.dumpRight, MekanismUtils.getRight(this.facing), dumpAmount);
            this.prevEnergy = this.getEnergy();
            int newRedstoneLevel = this.getRedstoneLevel();
            if (newRedstoneLevel != this.currentRedstoneLevel) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
                this.currentRedstoneLevel = newRedstoneLevel;
            }
        }
    }

    private void handleTank(GasTank tank, TileEntityGasTank.GasMode mode, EnumFacing side, int dumpAmount) {
        if (tank.getGas() != null) {
            if (mode != TileEntityGasTank.GasMode.DUMPING) {
                GasStack toSend = new GasStack(tank.getGas().getGas(), Math.min(tank.getStored(), this.output));
                tank.draw(GasUtils.emit(toSend, this, EnumSet.of(side)), true);
            } else {
                tank.draw(dumpAmount, true);
            }
            if (mode == TileEntityGasTank.GasMode.DUMPING_EXCESS && tank.getNeeded() < this.output) {
                tank.draw(this.output - tank.getNeeded(), true);
            }
        }
    }

    public int getUpgradedUsage(SeparatorRecipe recipe) {
        int possibleProcess;
        if (this.leftTank.getGasType() == ((ChemicalPairOutput)recipe.recipeOutput).leftGas.getGas()) {
            possibleProcess = this.leftTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).leftGas.amount;
            possibleProcess = Math.min(this.rightTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = this.leftTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).rightGas.amount;
            possibleProcess = Math.min(this.rightTank.getNeeded() / ((ChemicalPairOutput)recipe.recipeOutput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return Math.min(this.fluidTank.getFluidAmount() / ((FluidInput)recipe.recipeInput).ingredient.amount, possibleProcess);
    }

    public SeparatorRecipe getRecipe() {
        FluidInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((FluidInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getElectrolyticSeparatorRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public FluidInput getInput() {
        return new FluidInput(this.fluidTank.getFluid());
    }

    public boolean canOperate(SeparatorRecipe recipe) {
        return recipe != null && recipe.canOperate(this.fluidTank, this.leftTank, this.rightTank);
    }

    public int operate(SeparatorRecipe recipe) {
        int operations = this.getUpgradedUsage(recipe);
        recipe.operate(this.fluidTank, this.leftTank, this.rightTank, operations);
        return operations;
    }

    public boolean canFill(ChemicalPairOutput gases) {
        return this.leftTank.canReceive(gases.leftGas.getGas()) && this.leftTank.getNeeded() >= gases.leftGas.amount && this.rightTank.canReceive(gases.rightGas.getGas()) && this.rightTank.getNeeded() >= gases.rightGas.amount;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        if (slotID == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemstack) == null;
        }
        if (slotID == 1 || slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && ((IGasItem)itemstack.func_77973_b()).getGas((ItemStack)itemstack).amount == ((IGasItem)itemstack.func_77973_b()).getMaxGas(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(itemstack);
        }
        if (slotID == 1) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null || ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == MekanismFluids.Hydrogen);
        }
        if (slotID == 2) {
            return itemstack.func_77973_b() instanceof IGasItem && (((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null || ((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas() == MekanismFluids.Oxygen);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return true;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == MekanismUtils.getRight(this.facing)) {
            return new int[]{3};
        }
        if (side == this.facing || side == this.facing.func_176734_d()) {
            return new int[]{1, 2};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            byte type = dataStream.readByte();
            if (type == 0) {
                this.dumpLeft = TileEntityGasTank.GasMode.values()[this.dumpLeft.ordinal() == TileEntityGasTank.GasMode.values().length - 1 ? 0 : this.dumpLeft.ordinal() + 1];
            } else if (type == 1) {
                this.dumpRight = TileEntityGasTank.GasMode.values()[this.dumpRight.ordinal() == TileEntityGasTank.GasMode.values().length - 1 ? 0 : this.dumpRight.ordinal() + 1];
            }
            return;
        }
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            TileUtils.readTankData(dataStream, this.fluidTank);
            TileUtils.readTankData(dataStream, this.leftTank);
            TileUtils.readTankData(dataStream, this.rightTank);
            this.dumpLeft = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            this.dumpRight = TileEntityGasTank.GasMode.values()[dataStream.readInt()];
            this.clientEnergyUsed = dataStream.readDouble();
        }
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        TileUtils.addTankData(data, this.fluidTank);
        TileUtils.addTankData(data, this.leftTank);
        TileUtils.addTankData(data, this.rightTank);
        data.add(this.dumpLeft.ordinal());
        data.add(this.dumpRight.ordinal());
        data.add(this.clientEnergyUsed);
        return data;
    }

    @Override
    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.dumpLeft = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumpLeft")];
        this.dumpRight = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumpRight")];
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74768_a("dumpLeft", this.dumpLeft.ordinal());
        nbtTags.func_74768_a("dumpRight", this.dumpRight.ordinal());
        return nbtTags;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.BASE_MAX_ENERGY};
            }
            case 3: {
                return new Object[]{this.BASE_MAX_ENERGY - this.electricityStored};
            }
            case 4: {
                return new Object[]{this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0};
            }
            case 5: {
                return new Object[]{this.fluidTank.getFluid() != null ? this.fluidTank.getCapacity() - this.fluidTank.getFluid().amount : 0};
            }
            case 6: {
                return new Object[]{this.leftTank.getStored()};
            }
            case 7: {
                return new Object[]{this.leftTank.getNeeded()};
            }
            case 8: {
                return new Object[]{this.rightTank.getStored()};
            }
            case 9: {
                return new Object[]{this.rightTank.getNeeded()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fluidTank.getFluid() != null) {
            ItemDataUtils.setCompound(itemStack, "fluidTank", this.fluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.leftTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "leftTank", this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            ItemDataUtils.setCompound(itemStack, "rightTank", this.rightTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.fluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound(itemStack, "fluidTank")));
        this.leftTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(ItemDataUtils.getCompound(itemStack, "rightTank")));
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        return RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.containsRecipe(fluid.getFluid());
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        return this.fluidTank.fill(resource, doFill);
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        return 0;
    }

    @Override
    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank.draw(amount, doTransfer);
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return false;
    }

    @Override
    public boolean canDrawGas(EnumFacing side, Gas type) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank.getGas() != null && this.leftTank.getGas().getGas() == type;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank.getGas() != null && this.rightTank.getGas().getGas() == type;
        }
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.leftTank, this.rightTank};
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return (T)Capabilities.GAS_HANDLER_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY) {
            return side != null && side != MekanismUtils.getLeft(this.facing) && side != MekanismUtils.getRight(this.facing);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return side != null && side != this.facing && side != this.facing.func_176734_d() && side != MekanismUtils.getRight(this.facing);
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank, this.leftTank, this.rightTank};
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        if (upgrade == Upgrade.ENERGY) {
            this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
            this.energyPerTick = BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR.getUsage();
            this.setEnergy(Math.min(this.getMaxEnergy(), this.getEnergy()));
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }
}

