/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import me.lucko.luckperms.lib.configurate.objectmapping.DefaultObjectMapperFactory;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMapperFactory;
import me.lucko.luckperms.lib.configurate.objectmapping.serialize.TypeSerializerCollection;
import me.lucko.luckperms.lib.configurate.util.MapFactories;
import me.lucko.luckperms.lib.configurate.util.MapFactory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConfigurationOptions {
    private static final ConfigurationOptions DEFAULTS = new ConfigurationOptions(MapFactories.insertionOrdered(), null, TypeSerializerCollection.defaults(), null, DefaultObjectMapperFactory.getInstance(), false);
    private final @NonNull MapFactory mapFactory;
    private final @Nullable String header;
    private final @NonNull TypeSerializerCollection serializers;
    private final @Nullable ImmutableSet<Class<?>> acceptedTypes;
    private final @NonNull ObjectMapperFactory objectMapperFactory;
    private final boolean shouldCopyDefaults;

    private ConfigurationOptions(@NonNull MapFactory mapFactory, @Nullable String header, @NonNull TypeSerializerCollection serializers, @Nullable Set<Class<?>> acceptedTypes, @NonNull ObjectMapperFactory objectMapperFactory, boolean shouldCopyDefaults) {
        this.mapFactory = mapFactory;
        this.header = header;
        this.serializers = serializers;
        this.acceptedTypes = acceptedTypes == null ? null : ImmutableSet.copyOf(acceptedTypes);
        this.objectMapperFactory = objectMapperFactory;
        this.shouldCopyDefaults = shouldCopyDefaults;
    }

    public static @NonNull ConfigurationOptions defaults() {
        return DEFAULTS;
    }

    public @NonNull MapFactory getMapFactory() {
        return this.mapFactory;
    }

    @Deprecated
    public @NonNull ConfigurationOptions setMapFactory(@NonNull MapFactory mapFactory) {
        return this.withMapFactory(mapFactory);
    }

    public @NonNull ConfigurationOptions withMapFactory(@NonNull MapFactory mapFactory) {
        Objects.requireNonNull(mapFactory, "mapFactory");
        if (this.mapFactory == mapFactory) {
            return this;
        }
        return new ConfigurationOptions(mapFactory, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public @Nullable String getHeader() {
        return this.header;
    }

    public @NonNull ConfigurationOptions setHeader(@Nullable String header) {
        return this.withHeader(header);
    }

    public @NonNull ConfigurationOptions withHeader(@Nullable String header) {
        if (Objects.equals(this.header, header)) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public @NonNull TypeSerializerCollection getSerializers() {
        return this.serializers;
    }

    @Deprecated
    public @NonNull ConfigurationOptions setSerializers(@NonNull TypeSerializerCollection serializers) {
        return this.withSerializers(serializers);
    }

    public @NonNull ConfigurationOptions withSerializers(@NonNull TypeSerializerCollection serializers) {
        Objects.requireNonNull(serializers, "serializers");
        if (this.serializers == serializers) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public @NonNull ConfigurationOptions withSerializers(@NonNull Consumer<TypeSerializerCollection> serializerBuilder) {
        Objects.requireNonNull(serializerBuilder, "serializerBuilder");
        TypeSerializerCollection builder = this.serializers.newChild();
        serializerBuilder.accept(builder);
        return new ConfigurationOptions(this.mapFactory, this.header, builder, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public @NonNull ObjectMapperFactory getObjectMapperFactory() {
        return this.objectMapperFactory;
    }

    @Deprecated
    public @NonNull ConfigurationOptions setObjectMapperFactory(@NonNull ObjectMapperFactory objectMapperFactory) {
        return this.withObjectMapperFactory(objectMapperFactory);
    }

    public @NonNull ConfigurationOptions withObjectMapperFactory(@NonNull ObjectMapperFactory objectMapperFactory) {
        Objects.requireNonNull(objectMapperFactory, "factory");
        if (this.objectMapperFactory == objectMapperFactory) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, objectMapperFactory, this.shouldCopyDefaults);
    }

    public boolean acceptsType(@NonNull Class<?> type) {
        Objects.requireNonNull(type, "type");
        if (this.acceptedTypes == null) {
            return true;
        }
        if (this.acceptedTypes.contains(type)) {
            return true;
        }
        if (type.isPrimitive() && this.acceptedTypes.contains((Object)Primitives.wrap(type))) {
            return true;
        }
        if (Primitives.isWrapperType(type) && this.acceptedTypes.contains((Object)Primitives.unwrap(type))) {
            return true;
        }
        for (Class clazz : this.acceptedTypes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public @NonNull ConfigurationOptions setAcceptedTypes(@Nullable Set<Class<?>> acceptedTypes) {
        return this.withNativeTypes(acceptedTypes);
    }

    public @NonNull ConfigurationOptions withNativeTypes(@Nullable Set<Class<?>> acceptedTypes) {
        if (Objects.equals(this.acceptedTypes, acceptedTypes)) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, this.serializers, acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public boolean shouldCopyDefaults() {
        return this.shouldCopyDefaults;
    }

    @Deprecated
    public @NonNull ConfigurationOptions setShouldCopyDefaults(boolean shouldCopyDefaults) {
        return this.withShouldCopyDefaults(shouldCopyDefaults);
    }

    public @NonNull ConfigurationOptions withShouldCopyDefaults(boolean shouldCopyDefaults) {
        if (this.shouldCopyDefaults == shouldCopyDefaults) {
            return this;
        }
        return new ConfigurationOptions(this.mapFactory, this.header, this.serializers, (Set<Class<?>>)this.acceptedTypes, this.objectMapperFactory, shouldCopyDefaults);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationOptions)) {
            return false;
        }
        ConfigurationOptions that = (ConfigurationOptions)o;
        return Objects.equals(this.shouldCopyDefaults, that.shouldCopyDefaults) && Objects.equals(this.mapFactory, that.mapFactory) && Objects.equals(this.header, that.header) && Objects.equals(this.serializers, that.serializers) && Objects.equals(this.acceptedTypes, that.acceptedTypes) && Objects.equals(this.objectMapperFactory, that.objectMapperFactory);
    }

    public int hashCode() {
        return Objects.hash(this.mapFactory, this.header, this.serializers, this.acceptedTypes, this.objectMapperFactory, this.shouldCopyDefaults);
    }

    public String toString() {
        return "ConfigurationOptions{mapFactory=" + this.mapFactory + ", header='" + this.header + '\'' + ", serializers=" + this.serializers + ", acceptedTypes=" + this.acceptedTypes + ", objectMapperFactory=" + this.objectMapperFactory + ", shouldCopyDefaults=" + this.shouldCopyDefaults + '}';
    }
}

