/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.lib.configurate.objectmapping;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMapper;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMapperFactory;
import me.lucko.luckperms.lib.configurate.objectmapping.ObjectMappingException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultObjectMapperFactory
implements ObjectMapperFactory {
    private static final ObjectMapperFactory INSTANCE = new DefaultObjectMapperFactory();
    private final LoadingCache<TypeToken<?>, ObjectMapper<?>> mapperCache = CacheBuilder.newBuilder().weakKeys().maximumSize(500L).build(new CacheLoader<TypeToken<?>, ObjectMapper<?>>(){

        public ObjectMapper<?> load(TypeToken<?> key) throws Exception {
            return new ObjectMapper(key);
        }
    });

    public static @NonNull ObjectMapperFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull Class<T> type) throws ObjectMappingException {
        return this.getMapper(TypeToken.of(type));
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull TypeToken<T> type) throws ObjectMappingException {
        Objects.requireNonNull(type, "type");
        try {
            return (ObjectMapper)this.mapperCache.get(type);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new ObjectMappingException(e);
        }
    }

    public String toString() {
        return "DefaultObjectMapperFactory{}";
    }
}

