/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitAnalysing
extends AbstractTrait {
    public TraitAnalysing() {
        super("analysing", TextFormatting.GREEN);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onXpDrop(LivingExperienceDropEvent event) {
        EntityPlayer player = event.getAttackingPlayer();
        if (player != null && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)player.func_184614_ca()), (String)this.identifier) && event.getDroppedExperience() > 0) {
            event.setDroppedExperience(this.getUpdateXP(event.getDroppedExperience()));
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (!event.getWorld().field_72995_K && player != null && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)player.func_184614_ca()), (String)this.identifier) && event.getExpToDrop() > 0) {
            event.setExpToDrop(this.getUpdateXP(event.getExpToDrop()));
        }
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent event) {
        World w = event.getEntity().func_130014_f_();
        if (random.nextFloat() < 0.1f && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            if (!w.field_72995_K && event.getEntity() instanceof EntityMob && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)player.func_184614_ca()), (String)this.identifier)) {
                event.getDrops().clear();
            }
        }
    }

    private int getUpdateXP(int xp) {
        float exp = random.nextFloat() * random.nextFloat() * random.nextFloat() * ((float)xp + (float)random.nextInt(xp) * (1.0f + random.nextFloat()));
        return Math.round(exp);
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if ((double)random.nextFloat() < 0.1) {
            event.getDrops().clear();
        }
    }
}

