/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave;

import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.handlers.forge.HandleFluid;
import info.loenwind.autosave.handlers.forge.HandleFluidStack;
import info.loenwind.autosave.handlers.forge.HandleRegistryEntry;
import info.loenwind.autosave.handlers.internal.HandleStorable;
import info.loenwind.autosave.handlers.java.HandleArrayList;
import info.loenwind.autosave.handlers.java.HandleArrays;
import info.loenwind.autosave.handlers.java.HandleEnum;
import info.loenwind.autosave.handlers.java.HandleEnum2EnumMap;
import info.loenwind.autosave.handlers.java.HandleEnumMap;
import info.loenwind.autosave.handlers.java.HandleEnumSet;
import info.loenwind.autosave.handlers.java.HandleHashMap;
import info.loenwind.autosave.handlers.java.HandleHashSet;
import info.loenwind.autosave.handlers.java.HandlePrimitive;
import info.loenwind.autosave.handlers.java.HandleString;
import info.loenwind.autosave.handlers.java.util.HandleSimpleCollection;
import info.loenwind.autosave.handlers.minecraft.HandleBlockPos;
import info.loenwind.autosave.handlers.minecraft.HandleIBlockState;
import info.loenwind.autosave.handlers.minecraft.HandleItemStack;
import info.loenwind.autosave.handlers.util.DelegatingHandler;
import info.loenwind.autosave.util.BitUtil;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class Registry {
    @Nonnull
    public static final Registry GLOBAL_REGISTRY = new Registry(true);
    private final List<IHandler> handlers = new ArrayList<IHandler>();
    @Nullable
    private final Registry parent;

    private Registry(boolean root) {
        this.parent = root ? null : null;
    }

    public Registry() {
        this(GLOBAL_REGISTRY);
    }

    public Registry(Registry parent) {
        this.parent = parent;
    }

    public void register(IHandler handler) {
        this.handlers.add(handler);
    }

    public void registerPriority(IHandler handler) {
        this.handlers.add(0, handler);
    }

    public List<IHandler> findHandlers(Type type) throws InstantiationException, IllegalAccessException {
        ArrayList<IHandler> result = new ArrayList<IHandler>();
        Class<?> clazz = TypeUtil.toClass(type);
        Storable annotation = clazz.getAnnotation(Storable.class);
        while (annotation != null) {
            Class<?> superclass;
            if (annotation.handler() != HandleStorable.class) {
                result.add(annotation.handler().newInstance());
            }
            if ((superclass = clazz.getSuperclass()) == null) break;
            annotation = superclass.getAnnotation(Storable.class);
            clazz = superclass;
        }
        this.findRegisteredHandlers(this, type, result);
        return result;
    }

    private void findRegisteredHandlers(Registry caller, Type type, List<IHandler> result) {
        for (IHandler iHandler : this.handlers) {
            IHandler iHandler2 = iHandler.getHandler(caller, type);
            if (iHandler2 == null) continue;
            result.add(iHandler2);
        }
        Registry thisParent = this.parent;
        if (thisParent != null) {
            thisParent.findRegisteredHandlers(caller, type, result);
        }
    }

    static {
        GLOBAL_REGISTRY.register(new HandlePrimitive<Boolean>(false, Boolean.class, Boolean.TYPE, NBTTagCompound::func_74757_a, NBTTagCompound::func_74767_n));
        GLOBAL_REGISTRY.register(new HandlePrimitive<Character>(Character.valueOf('\u0000'), Character.class, Character.TYPE, (nbt, name, c) -> nbt.func_74768_a(name, (int)c.charValue()), (nbt, name) -> Character.valueOf((char)nbt.func_74762_e(name))));
        GLOBAL_REGISTRY.register(new HandlePrimitive<Byte>((byte)0, Byte.class, Byte.TYPE, NBTTagCompound::func_74774_a, NBTTagCompound::func_74771_c));
        GLOBAL_REGISTRY.register(new HandlePrimitive<Short>((short)0, Short.class, Short.TYPE, NBTTagCompound::func_74777_a, NBTTagCompound::func_74765_d));
        GLOBAL_REGISTRY.register(new HandlePrimitive<Integer>(0, Integer.class, Integer.TYPE, NBTTagCompound::func_74768_a, NBTTagCompound::func_74762_e));
        GLOBAL_REGISTRY.register(new HandlePrimitive<Long>(0L, Long.class, Long.TYPE, NBTTagCompound::func_74772_a, NBTTagCompound::func_74763_f));
        GLOBAL_REGISTRY.register(new HandlePrimitive<Float>(Float.valueOf(0.0f), Float.class, Float.TYPE, NBTTagCompound::func_74776_a, NBTTagCompound::func_74760_g));
        GLOBAL_REGISTRY.register(new HandlePrimitive<Double>(0.0, Double.class, Double.TYPE, NBTTagCompound::func_74780_a, NBTTagCompound::func_74769_h));
        GLOBAL_REGISTRY.register(new HandleEnum());
        GLOBAL_REGISTRY.register(new HandleString());
        HandlePrimitive<byte[]> byteArrayHandler = new HandlePrimitive<byte[]>(new byte[0], byte[].class, null, NBTTagCompound::func_74773_a, NBTTagCompound::func_74770_j);
        GLOBAL_REGISTRY.register(byteArrayHandler);
        GLOBAL_REGISTRY.register(new DelegatingHandler<Byte[], byte[]>(Byte[].class, byteArrayHandler, ArrayUtils::toPrimitive, ArrayUtils::toObject));
        HandlePrimitive<int[]> intArrayHandler = new HandlePrimitive<int[]>(new int[0], int[].class, null, NBTTagCompound::func_74783_a, NBTTagCompound::func_74759_k);
        GLOBAL_REGISTRY.register(intArrayHandler);
        GLOBAL_REGISTRY.register(new DelegatingHandler<Integer[], int[]>(Integer[].class, intArrayHandler, ArrayUtils::toPrimitive, ArrayUtils::toObject));
        HandlePrimitive<short[]> shortArrayHandler = new HandlePrimitive<short[]>(new short[0], short[].class, null, (nbt, name, arr) -> {
            int[] ret = new int[((short[])arr).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = arr[i];
            }
            nbt.func_74783_a(name, ret);
        }, (nbt, name) -> {
            int[] read = nbt.func_74759_k(name);
            short[] ret = new short[read.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (short)read[i];
            }
            return ret;
        });
        GLOBAL_REGISTRY.register(shortArrayHandler);
        GLOBAL_REGISTRY.register(new DelegatingHandler<Short[], short[]>(Short[].class, shortArrayHandler, ArrayUtils::toPrimitive, ArrayUtils::toObject));
        HandlePrimitive<char[]> charArrayHandler = new HandlePrimitive<char[]>(new char[0], char[].class, null, (nbt, name, arr) -> {
            int[] ret = new int[((char[])arr).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = arr[i];
            }
            nbt.func_74783_a(name, ret);
        }, (nbt, name) -> {
            int[] read = nbt.func_74759_k(name);
            char[] ret = new char[read.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (char)read[i];
            }
            return ret;
        });
        GLOBAL_REGISTRY.register(charArrayHandler);
        GLOBAL_REGISTRY.register(new DelegatingHandler<Character[], char[]>(Character[].class, charArrayHandler, ArrayUtils::toPrimitive, ArrayUtils::toObject));
        HandlePrimitive<float[]> floatArrayHandler = new HandlePrimitive<float[]>(new float[0], float[].class, null, (nbt, name, arr) -> {
            int[] ret = new int[((float[])arr).length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Float.floatToIntBits(arr[i]);
            }
            nbt.func_74783_a(name, ret);
        }, (nbt, name) -> {
            int[] read = nbt.func_74759_k(name);
            float[] ret = new float[read.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = Float.intBitsToFloat(read[i]);
            }
            return ret;
        });
        GLOBAL_REGISTRY.register(floatArrayHandler);
        GLOBAL_REGISTRY.register(new DelegatingHandler<Float[], float[]>(Float[].class, floatArrayHandler, ArrayUtils::toPrimitive, ArrayUtils::toObject));
        HandlePrimitive<long[]> longArrayHandler = new HandlePrimitive<long[]>(new long[0], long[].class, null, (nbt, name, arr) -> {
            int[] ret = new int[((long[])arr).length * 2];
            for (int i = 0; i < ((long[])arr).length; ++i) {
                ret[i * 2] = BitUtil.getLongMSB(arr[i]);
                ret[i * 2 + 1] = BitUtil.getLongLSB(arr[i]);
            }
            nbt.func_74783_a(name, ret);
        }, (nbt, name) -> {
            int[] read = nbt.func_74759_k(name);
            long[] ret = new long[read.length / 2];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = BitUtil.longFromInts(read[i * 2], read[i * 2 + 1]);
            }
            return ret;
        });
        GLOBAL_REGISTRY.register(longArrayHandler);
        GLOBAL_REGISTRY.register(new DelegatingHandler<Long[], long[]>(Long[].class, longArrayHandler, ArrayUtils::toPrimitive, ArrayUtils::toObject));
        DelegatingHandler<double[], long[]> doubleArrayHandler = new DelegatingHandler<double[], long[]>(double[].class, longArrayHandler, doubleArr -> Arrays.stream(doubleArr).mapToLong(d -> Double.doubleToLongBits(d)).toArray(), longArr -> Arrays.stream(longArr).mapToDouble(l -> Double.longBitsToDouble(l)).toArray());
        GLOBAL_REGISTRY.register(doubleArrayHandler);
        GLOBAL_REGISTRY.register(new DelegatingHandler<Double[], double[]>(Double[].class, doubleArrayHandler, ArrayUtils::toPrimitive, ArrayUtils::toObject));
        GLOBAL_REGISTRY.register(new HandleArrays());
        GLOBAL_REGISTRY.register(new HandleArrayList());
        GLOBAL_REGISTRY.register(new HandleSimpleCollection<LinkedList>(LinkedList.class));
        GLOBAL_REGISTRY.register(new HandleHashSet());
        GLOBAL_REGISTRY.register(new HandleEnumSet());
        GLOBAL_REGISTRY.register(new HandleHashMap());
        GLOBAL_REGISTRY.register(new HandleEnum2EnumMap());
        GLOBAL_REGISTRY.register(new HandleEnumMap());
        GLOBAL_REGISTRY.register(new HandleRegistryEntry());
        GLOBAL_REGISTRY.register(new HandleItemStack());
        GLOBAL_REGISTRY.register(new HandleBlockPos());
        GLOBAL_REGISTRY.register(new HandleIBlockState());
        GLOBAL_REGISTRY.register(new DelegatingHandler<ResourceLocation, String>(ResourceLocation.class, new HandleString(), ResourceLocation::toString, ResourceLocation::new));
        GLOBAL_REGISTRY.register(new HandleFluidStack());
        GLOBAL_REGISTRY.register(new HandleFluid());
        GLOBAL_REGISTRY.register(new HandleStorable());
    }
}

