/*
 * Decompiled with CFR 0.152.
 */
package com.carrot.carrotshop;

import com.carrot.carrotshop.CarrotShop;
import com.carrot.carrotshop.Lang;
import com.carrot.carrotshop.serializer.CurrencySerializer;
import com.carrot.carrotshop.serializer.InventorySerializer;
import com.carrot.carrotshop.shop.Bank;
import com.carrot.carrotshop.shop.Buy;
import com.carrot.carrotshop.shop.Cmd;
import com.carrot.carrotshop.shop.DeviceOff;
import com.carrot.carrotshop.shop.DeviceOn;
import com.carrot.carrotshop.shop.Heal;
import com.carrot.carrotshop.shop.Sell;
import com.carrot.carrotshop.shop.Shop;
import com.carrot.carrotshop.shop.Toggle;
import com.carrot.carrotshop.shop.Trade;
import com.carrot.carrotshop.shop.aBuy;
import com.carrot.carrotshop.shop.aDeviceOff;
import com.carrot.carrotshop.shop.aDeviceOn;
import com.carrot.carrotshop.shop.aSell;
import com.carrot.carrotshop.shop.aToggle;
import com.carrot.carrotshop.shop.aTrade;
import com.carrot.carrotshop.shop.iBuy;
import com.carrot.carrotshop.shop.iSell;
import com.carrot.carrotshop.shop.iTrade;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.UUID;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializerCollection;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class ShopsData {
    private static File carrotshopsFile;
    private static File cmdsDir;
    private static ConfigurationNode shopsNode;
    private static ConfigurationLoader<CommentedConfigurationNode> loader;
    private static Map<Location<World>, List<Shop>> shops;
    private static Hashtable<UUID, Stack<Location<World>>> storedLocations;
    private static HashSet<UUID> soldThings;
    private static Currency currency;

    public static void init(File rootDir) throws IOException {
        cmdsDir = new File(rootDir, "cmds");
        cmdsDir.mkdirs();
        carrotshopsFile = new File(rootDir, "shops.json");
        carrotshopsFile.createNewFile();
        cmdsDir = new File(rootDir, "cmds");
        cmdsDir.mkdirs();
        TypeSerializerCollection serializers = TypeSerializers.getDefaultSerializers().newChild();
        serializers.registerType(TypeToken.of(Inventory.class), (TypeSerializer)new InventorySerializer());
        serializers.registerType(TypeToken.of(Currency.class), (TypeSerializer)new CurrencySerializer());
        ConfigurationOptions options = ConfigurationOptions.defaults().setSerializers(serializers);
        loader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(carrotshopsFile)).build();
        shopsNode = loader.load(options);
    }

    public static void load() {
        boolean hasErrors = false;
        if (CarrotShop.getEcoService() != null) {
            String candidateCurrencyID = shopsNode.getNode(new Object[]{"globalconfig", "currency"}).getString();
            for (Currency cur : CarrotShop.getEcoService().getCurrencies()) {
                if (!cur.getId().equals(candidateCurrencyID)) continue;
                currency = cur;
            }
        }
        for (ConfigurationNode soldThingsNode : shopsNode.getNode(new Object[]{"notifications", "soldthings"}).getChildrenList()) {
            try {
                soldThings.add((UUID)soldThingsNode.getValue(TypeToken.of(UUID.class)));
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
                hasErrors = true;
            }
        }
        for (ConfigurationNode shopNode : shopsNode.getNode(new Object[]{"shops"}).getChildrenList()) {
            try {
                ShopsData.pushShop((Shop)shopNode.getNode(new Object[]{"shop"}).getValue(TypeToken.of(Class.forName(shopNode.getNode(new Object[]{"type"}).getString()))));
            }
            catch (Exception e) {
                e.printStackTrace();
                hasErrors = true;
            }
        }
        if (hasErrors) {
            CarrotShop.getLogger().warn(Lang.CONSOLE_ERROR_LOAD);
        }
    }

    public static void unload() {
        ShopsData.save();
        storedLocations.clear();
        shops.forEach((location, shoplist) -> shoplist.forEach(shop -> shop.setReset()));
        shops.clear();
    }

    public static void save() {
        boolean hasErrors = false;
        if (CarrotShop.getEcoService() != null) {
            shopsNode.getNode(new Object[]{"globalconfig", "currency"}).setValue((Object)ShopsData.getCurrency().getId());
        }
        shopsNode.getNode(new Object[]{"notifications"}).removeChild((Object)"soldthings");
        for (UUID uUID : soldThings) {
            try {
                shopsNode.getNode(new Object[]{"notifications", "soldthings"}).getAppendedNode().setValue(TypeToken.of(UUID.class), (Object)uUID);
            }
            catch (ObjectMappingException e) {
                e.printStackTrace();
            }
        }
        shopsNode.removeChild((Object)"shops");
        for (Map.Entry entry : shops.entrySet()) {
            for (Shop shop : (List)entry.getValue()) {
                if (!((Location)entry.getKey()).equals(shop.getLocation())) continue;
                ConfigurationNode shopNode = shopsNode.getNode(new Object[]{"shops"}).getAppendedNode();
                try {
                    if (shop instanceof iTrade) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(iTrade.class), (Object)((iTrade)shop));
                    } else if (shop instanceof iBuy) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(iBuy.class), (Object)((iBuy)shop));
                    } else if (shop instanceof iSell) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(iSell.class), (Object)((iSell)shop));
                    } else if (shop instanceof aTrade) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(aTrade.class), (Object)((aTrade)shop));
                    } else if (shop instanceof aBuy) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(aBuy.class), (Object)((aBuy)shop));
                    } else if (shop instanceof aSell) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(aSell.class), (Object)((aSell)shop));
                    } else if (shop instanceof Trade) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(Trade.class), (Object)((Trade)shop));
                    } else if (shop instanceof Buy) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(Buy.class), (Object)((Buy)shop));
                    } else if (shop instanceof Sell) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(Sell.class), (Object)((Sell)shop));
                    } else if (shop instanceof Bank) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(Bank.class), (Object)((Bank)shop));
                    } else if (shop instanceof Heal) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(Heal.class), (Object)((Heal)shop));
                    } else if (shop instanceof Cmd) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(Cmd.class), (Object)((Cmd)shop));
                    } else if (shop instanceof DeviceOn) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(DeviceOn.class), (Object)((DeviceOn)shop));
                    } else if (shop instanceof DeviceOff) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(DeviceOff.class), (Object)((DeviceOff)shop));
                    } else if (shop instanceof Toggle) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(Toggle.class), (Object)((Toggle)shop));
                    } else if (shop instanceof aDeviceOn) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(aDeviceOn.class), (Object)((aDeviceOn)shop));
                    } else if (shop instanceof aDeviceOff) {
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(aDeviceOff.class), (Object)((aDeviceOff)shop));
                    } else {
                        if (!(shop instanceof aToggle)) continue;
                        shopNode.getNode(new Object[]{"shop"}).setValue(TypeToken.of(aToggle.class), (Object)((aToggle)shop));
                    }
                    shopNode.getNode(new Object[]{"type"}).setValue((Object)shop.getClass().getName());
                }
                catch (ObjectMappingException e) {
                    e.printStackTrace();
                    hasErrors = true;
                }
            }
        }
        try {
            loader.save(shopsNode);
        }
        catch (Exception e) {
            e.printStackTrace();
            hasErrors = true;
        }
        if (hasErrors) {
            CarrotShop.getLogger().error("Unable to save all CarrotShops");
        }
    }

    private static void pushShop(Shop shop) {
        for (Location<World> location : shop.getLocations()) {
            List shopLoc = shops.getOrDefault(location, new ArrayList());
            shopLoc.add(shop);
            shops.put(location, shopLoc);
        }
        shop.update();
    }

    public static void addShop(Shop shop) {
        ShopsData.pushShop(shop);
        ShopsData.save();
    }

    public static void delShop(Shop shop) {
        shop.setReset();
        for (Location<World> location : shop.getLocations()) {
            List<Shop> shopLoc = shops.get(location);
            if (shopLoc == null) continue;
            shopLoc.remove(shop);
            if (shopLoc.isEmpty()) {
                shops.remove(location);
                continue;
            }
            shops.put(location, shopLoc);
        }
        ShopsData.save();
    }

    public static Optional<List<Shop>> getShops(Location<World> loc) {
        if (shops.containsKey(loc)) {
            return Optional.of(shops.get(loc));
        }
        return Optional.empty();
    }

    public static void storeItemLocation(Player player, Location<World> loc) {
        Stack<Location<World>> items = storedLocations.getOrDefault(player.getUniqueId(), new Stack());
        if (items.contains(loc)) {
            items.remove(loc);
            player.sendMessage((Text)Text.of((String)Lang.LOCATION_REMOVED));
            return;
        }
        items.push(loc);
        player.sendMessage((Text)Text.of((String)Lang.LOCATION_STORED));
        storedLocations.put(player.getUniqueId(), items);
    }

    public static Stack<Location<World>> getItemLocations(Player player) {
        return storedLocations.getOrDefault(player.getUniqueId(), new Stack());
    }

    public static void clearItemLocations(Player player) {
        storedLocations.remove(player.getUniqueId());
    }

    public static void setCurrency(Currency cur) {
        currency = cur;
        ShopsData.save();
    }

    public static Currency getCurrency() {
        if (CarrotShop.getEcoService() == null) {
            return null;
        }
        if (currency != null) {
            return currency;
        }
        return CarrotShop.getEcoService().getDefaultCurrency();
    }

    public static boolean hasMultipleCurrencies() {
        return CarrotShop.getEcoService() != null && CarrotShop.getEcoService().getCurrencies().size() > 1;
    }

    public static void soldSomethingOffline(UUID uuid) {
        if (!soldThings.contains(uuid)) {
            soldThings.add(uuid);
            ShopsData.save();
        }
    }

    public static boolean hasSoldSomethingOffline(UUID uuid) {
        boolean ret = false;
        if (soldThings.contains(uuid)) {
            ret = true;
            soldThings.remove(uuid);
            ShopsData.save();
        }
        return ret;
    }

    public static File getCmdsDirs() {
        return cmdsDir;
    }

    static {
        shops = new HashMap<Location<World>, List<Shop>>();
        storedLocations = new Hashtable();
        soldThings = new HashSet();
        currency = null;
    }
}

