/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ModuleBase;

public class ModuleSeat
extends ModuleBase {
    private int[] buttonRect = new int[]{20, 20, 24, 12};
    private boolean relative;
    private float chairAngle;

    public ModuleSeat(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 55;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/chair.png");
        int imageID = this.getState();
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = imageID == 0 ? 2 : 1;
        }
        this.drawImage(gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 3 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, this.getStateName(), x, y, this.buttonRect);
    }

    private int getState() {
        if (this.getCart().getCartRider() == null) {
            return 1;
        }
        if (this.getCart().getCartRider() == this.getClientPlayer()) {
            return 2;
        }
        return 0;
    }

    private String getStateName() {
        return Localization.MODULES.ATTACHMENTS.SEAT_MESSAGE.translate(String.valueOf(this.getState()));
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0 && player != null) {
            if (this.getCart().getCartRider() == null) {
                player.func_184220_m((Entity)this.getCart());
            } else if (this.getCart().getCartRider() == player) {
                player.func_184210_p();
            }
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().getCartRider() != null) {
            this.relative = false;
            this.chairAngle = (float)(Math.PI + Math.PI * (double)this.getCart().getCartRider().field_70177_z / 180.0);
        } else {
            this.relative = true;
            this.chairAngle = 1.5707964f;
        }
    }

    public float getChairAngle() {
        return this.chairAngle;
    }

    public boolean useRelativeRender() {
        return this.relative;
    }

    @Override
    public float mountedOffset(Entity rider) {
        return -0.1f;
    }
}

