/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command;

import icbm.classic.content.entity.EntityExplosion;
import icbm.classic.content.entity.EntityExplosive;
import icbm.classic.content.entity.EntityFlyingBlock;
import icbm.classic.content.entity.EntityFragments;
import icbm.classic.content.entity.EntityGrenade;
import icbm.classic.content.entity.missile.EntityMissile;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class CommandUtils {
    public static String[] removeFront(String[] args) {
        if (args.length == 0 || args.length == 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(args, 1, args.length);
    }

    public static boolean isICBMEntity(Entity entity) {
        return entity instanceof EntityFragments || entity instanceof EntityFlyingBlock || CommandUtils.isMissile(entity) || entity instanceof EntityExplosive || entity instanceof EntityExplosion || entity instanceof EntityGrenade;
    }

    public static boolean isMissile(Entity entity) {
        return entity instanceof EntityMissile;
    }

    public static List<Entity> getEntities(World world, double x, double y, double z, double range, Predicate<Entity> filter) {
        if (range > 0.0) {
            AxisAlignedBB bb = new AxisAlignedBB(x - range, y - range, z - range, x + range, y + range, z + range);
            return world.func_175647_a(Entity.class, bb, filter::test);
        }
        return world.field_72996_f.stream().filter(filter).collect(Collectors.toList());
    }

    public static int parseRadius(String input) throws WrongUsageException {
        try {
            int radius = Integer.parseInt(input);
            if (radius <= 0) {
                throw new WrongUsageException("Radius must be greater than zero!", new Object[0]);
            }
            return radius;
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("Invalid radius!", new Object[0]);
        }
    }

    public static double getNumber(ICommandSender sender, String value, double alt) throws WrongUsageException {
        if (value.equals("~")) {
            if (!(sender instanceof MinecraftServer)) {
                return alt;
            }
            throw new WrongUsageException("'~' can't be used from console", new Object[0]);
        }
        if (value.startsWith("~")) {
            if (!(sender instanceof MinecraftServer)) {
                return alt + Double.parseDouble(value.substring(1));
            }
            throw new WrongUsageException("'~' can't be used from console", new Object[0]);
        }
        return Double.parseDouble(value);
    }

    public static World getWorld(ICommandSender sender, String value, World alt) throws WrongUsageException {
        if (value.equals("~")) {
            if (!(sender instanceof MinecraftServer)) {
                return alt;
            }
            throw new WrongUsageException("'~' can't be used from console", new Object[0]);
        }
        try {
            int dim = Integer.parseInt(value);
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world == null) {
                throw new WrongUsageException("Dimension with ID[" + value + "] was not found!", new Object[0]);
            }
            return world;
        }
        catch (NumberFormatException e) {
            throw new WrongUsageException("Invalid dimension ID[" + value + "]!", new Object[0]);
        }
    }
}

