/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.command.sub.blast;

import icbm.classic.api.explosion.BlastState;
import icbm.classic.api.reg.IExplosiveData;
import icbm.classic.command.CommandUtils;
import icbm.classic.command.sub.blast.CommandBlastTrigger;
import icbm.classic.command.system.SubCommand;
import icbm.classic.lib.explosive.ExplosiveHandler;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.SyntaxErrorException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CommandBlastSpread
extends SubCommand {
    private static final String TRANSLATION_KEY = "command.icbmclassic:icbm.spread";
    public static final String TRANSLATION_SPREAD_START = "command.icbmclassic:icbm.spread.started";

    public CommandBlastSpread() {
        super("spread");
    }

    @Override
    protected void collectHelpForAll(Consumer<String> consumer) {
        consumer.accept("<count> <distance> <id> <dim> <x> <y> <z> <scale>");
    }

    @Override
    public void handleCommand(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (args.length != 8) {
            throw new WrongUsageException("command.icbmclassic:icbm.error.unknown.command", new Object[]{this.getUsage(sender)});
        }
        this.doCommand(sender, args);
    }

    private void doCommand(@Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        int count = CommandBase.func_180528_a((String)args[0], (int)1);
        int distance = CommandBase.func_180528_a((String)args[1], (int)1);
        IExplosiveData explosiveData = CommandBlastTrigger.getExplosive(args[2]);
        World world = CommandUtils.getWorld(sender, args[3], sender.func_130014_f_());
        double xInput = CommandUtils.getNumber(sender, args[4], (double)sender.func_180425_c().func_177958_n() + 0.5);
        double yInput = CommandUtils.getNumber(sender, args[5], (double)sender.func_180425_c().func_177956_o() + 0.5);
        double zInput = CommandUtils.getNumber(sender, args[6], (double)sender.func_180425_c().func_177952_p() + 0.5);
        float scale = Float.parseFloat(args[7]);
        if (scale <= 0.0f) {
            throw new SyntaxErrorException("command.icbmclassic:icbm.blast.error.scale.zero", new Object[0]);
        }
        int expectedSpawnCount = (int)Math.floor(Math.pow(count * 2 + 1, 2.0));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(TRANSLATION_SPREAD_START, new Object[]{explosiveData.getRegistryName(), Float.valueOf(scale), world.field_73011_w.getDimension(), world.func_175624_G().func_77127_a(), xInput, yInput, zInput, count, distance, expectedSpawnCount}));
        for (int xi = -count; xi <= count; ++xi) {
            for (int zi = -count; zi <= count; ++zi) {
                double x = xInput + (double)(xi * distance);
                double z = zInput + (double)(zi * distance);
                BlastState result = ExplosiveHandler.createExplosion(null, world, x, yInput, z, explosiveData.getRegistryID(), scale, null);
                if (result == BlastState.TRIGGERED || result == BlastState.THREADING) continue;
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(CommandBlastTrigger.getTranslationKey(result), new Object[]{explosiveData.getRegistryName(), Float.valueOf(scale), world.field_73011_w.getDimension(), world.func_175624_G().func_77127_a(), x, yInput, z}));
            }
        }
    }
}

