/*
 * Decompiled with CFR 0.152.
 */
package icbm.classic.content.blast;

import icbm.classic.ICBMClassic;
import icbm.classic.api.ExplosiveRefs;
import icbm.classic.api.explosion.IBlastTickable;
import icbm.classic.client.ICBMSounds;
import icbm.classic.content.blast.Blast;
import icbm.classic.content.blast.BlastMutation;
import icbm.classic.content.potion.CustomPotionEffect;
import icbm.classic.lib.transform.vector.Pos;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlastGasBase
extends Blast
implements IBlastTickable {
    public static final DamageSource CONTAGIUS_DAMAGE = new DamageSource("icbm.contagious");
    public static final DamageSource CHEMICAL_DAMAGE = new DamageSource("icbm.chemical");
    private static final int TICKS_BETWEEN_RUNS = 5;
    private static final BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
    private int duration;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private boolean playShortSoundFX;
    private boolean applyConfusionEffect;
    private boolean applyPoisonEffect;
    private boolean applyContagiousEffect;
    private boolean mutateEntities;
    private int lastRadius = 0;
    private HashSet<BlockPos> affectedBlocks = new HashSet();
    private Queue<BlockPos> edgeBlocks = new LinkedList<BlockPos>();
    private HashMap<EntityLivingBase, Integer> impactedEntityMap = new HashMap();

    public BlastGasBase(int duration, boolean playShortSoundFX) {
        this.duration = duration;
        this.playShortSoundFX = playShortSoundFX;
    }

    private double sizePercentageOverTime(int timePassed) {
        return Math.min(1.0f, 2.0f * (float)timePassed / (float)this.duration + 0.1f);
    }

    public BlastGasBase setRGB(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        return this;
    }

    public BlastGasBase setConfuse() {
        this.applyConfusionEffect = true;
        return this;
    }

    public BlastGasBase setPoison() {
        this.applyPoisonEffect = true;
        return this;
    }

    public BlastGasBase setContagious() {
        this.applyContagiousEffect = true;
        this.mutateEntities = true;
        return this;
    }

    @Override
    public boolean doExplode(int callCount) {
        if (callCount == 0 && !this.playShortSoundFX) {
            ICBMSounds.DEBILITATION.play(this.field_77287_j, this.location.x(), this.location.y(), this.location.z(), 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
        }
        if (callCount % 5 == 0) {
            this.setEffectBoundsAndSpawnParticles(this.callCount);
            this.generateAudioEffect();
            if (this.applyConfusionEffect || this.applyContagiousEffect || this.applyPoisonEffect || this.mutateEntities) {
                double radius = this.getBlastRadius();
                AxisAlignedBB bounds = new AxisAlignedBB(this.location.x() - radius, this.location.y() - radius, this.location.z() - radius, this.location.x() + radius, this.location.y() + radius, this.location.z() + radius);
                List entityList = this.world().func_175647_a(EntityLivingBase.class, bounds, this::canGasEffect);
                for (EntityLivingBase entity : entityList) {
                    if (!this.impactedEntityMap.containsKey(entity)) {
                        this.impactedEntityMap.put(entity, 1);
                    } else {
                        this.impactedEntityMap.replace(entity, this.impactedEntityMap.get(entity) + 1);
                    }
                    int hitCount = this.impactedEntityMap.get(entity);
                    if (this.applyContagiousEffect) {
                        ICBMClassic.contagios_potion.poisonEntity(this.location.toPos(), entity, 3);
                        if (hitCount > 10) {
                            entity.func_70097_a(CONTAGIUS_DAMAGE, ((float)hitCount - 10.0f) / 5.0f);
                        }
                    }
                    if (this.applyPoisonEffect) {
                        ICBMClassic.poisonous_potion.poisonEntity(this.location.toPos(), entity);
                        if (hitCount > 20) {
                            entity.func_70097_a(CHEMICAL_DAMAGE, ((float)hitCount - 10.0f) / 10.0f);
                        }
                    }
                    if (!this.applyConfusionEffect) continue;
                    entity.func_70690_d((PotionEffect)new CustomPotionEffect(MobEffects.field_76436_u, 360, 0));
                    entity.func_70690_d((PotionEffect)new CustomPotionEffect(MobEffects.field_76419_f, 1200, 0));
                    entity.func_70690_d((PotionEffect)new CustomPotionEffect(MobEffects.field_76421_d, 1200, 2));
                }
            }
            if (this.mutateEntities) {
                new BlastMutation().setBlastWorld(this.world()).setBlastSource(this.field_77283_e).setBlastPosition(this.location.x(), this.location.y(), this.location.z()).setBlastSize(this.getBlastRadius()).setExplosiveData(ExplosiveRefs.MUTATION).buildBlast().runBlast();
            }
            return this.callCount > this.duration;
        }
        return false;
    }

    private boolean canGasEffect(EntityLivingBase entity) {
        if (entity.func_70089_S()) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                return false;
            }
            if (this.applyContagiousEffect && entity.func_180431_b(CONTAGIUS_DAMAGE)) {
                return false;
            }
            if (this.applyPoisonEffect && entity.func_180431_b(CHEMICAL_DAMAGE)) {
                return false;
            }
            return this.affectedBlocks.contains(checkPos.func_189532_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v));
        }
        return false;
    }

    private void generateAudioEffect() {
        if (this.playShortSoundFX) {
            ICBMSounds.GAS_LEAK.play(this.field_77287_j, this.location.x() + 0.5, this.location.y() + 0.5, this.location.z() + 0.5, 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f, true);
        }
    }

    private void setEffectBoundsAndSpawnParticles(int timePassed) {
        int maxSize = (int)Math.ceil(this.getBlastRadius());
        int radius = (int)Math.floor((double)maxSize * this.sizePercentageOverTime(timePassed));
        if (this.lastRadius == radius) {
            return;
        }
        this.lastRadius = radius;
        int currentDistanceSQ = radius * radius;
        if (this.affectedBlocks.isEmpty()) {
            this.affectedBlocks.add(this.getPos());
            this.edgeBlocks.add(this.getPos());
        }
        if (this.edgeBlocks.isEmpty()) {
            this.affectedBlocks.stream().filter(pos -> Math.random() > 0.5).forEach(pos -> this.edgeBlocks.add((BlockPos)pos));
        }
        HashSet<BlockPos> hasPathed = new HashSet<BlockPos>();
        LinkedList<BlockPos> nextSet = new LinkedList<BlockPos>();
        while (this.edgeBlocks.peek() != null) {
            BlockPos edge = this.edgeBlocks.poll();
            for (EnumFacing facing : EnumFacing.values()) {
                checkPos.func_189533_g((Vec3i)edge);
                checkPos.func_189536_c(facing);
                if (hasPathed.contains(checkPos) || this.affectedBlocks.contains(checkPos) || !this.isInRange((BlockPos)checkPos, currentDistanceSQ)) continue;
                if (this.isValidPath((BlockPos)checkPos)) {
                    BlockPos pos2 = checkPos.func_185334_h();
                    this.affectedBlocks.add(pos2);
                    nextSet.add(pos2);
                    this.spawnGasParticles(pos2);
                    continue;
                }
                hasPathed.add(checkPos.func_185334_h());
            }
        }
        this.edgeBlocks.addAll(nextSet);
    }

    private boolean isValidPath(BlockPos pos) {
        IBlockState blockState = this.field_77287_j.func_180495_p(pos);
        return !blockState.func_185913_b();
    }

    private boolean isInRange(BlockPos pos, int radiusSq) {
        return (int)Math.floor(pos.func_177954_c((double)this.xi(), (double)this.yi(), (double)this.zi())) <= radiusSq;
    }

    private void spawnGasParticles(BlockPos pos) {
        for (int j = 0; j < 1; ++j) {
            ICBMClassic.proxy.spawnAirParticle(this.field_77287_j, new Pos(pos), (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0 - 0.1, (Math.random() - 0.5) / 2.0, this.red, this.green, this.blue, 7.0f, this.duration);
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.duration = nbt.func_74762_e("duration");
        this.applyContagiousEffect = nbt.func_74767_n("isContagious");
        this.applyPoisonEffect = nbt.func_74767_n("isPoisonous");
        this.applyConfusionEffect = nbt.func_74767_n("isConfuse");
        this.mutateEntities = nbt.func_74767_n("isMutate");
        this.red = nbt.func_74760_g("red");
        this.green = nbt.func_74760_g("green");
        this.blue = nbt.func_74760_g("blue");
        this.playShortSoundFX = nbt.func_74767_n("playShortSoundFX");
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74757_a("isContagious", this.applyContagiousEffect);
        nbt.func_74757_a("isPoisonous", this.applyPoisonEffect);
        nbt.func_74757_a("isConfuse", this.applyConfusionEffect);
        nbt.func_74757_a("isMutate", this.mutateEntities);
        nbt.func_74776_a("red", this.red);
        nbt.func_74776_a("green", this.green);
        nbt.func_74776_a("blue", this.blue);
        nbt.func_74757_a("playShortSoundFX", this.playShortSoundFX);
    }
}

